/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks.movement;

import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.ElementPriority;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.modified.client.entity.LocalPlayerModified;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVisorTask
public class TaskRoomMovement
extends VisorTask {
    private static final String ID = "room_movement";
    private static TaskRoomMovement instance;
    private int freezeMovementTimer;

    public TaskRoomMovement(@NotNull VisorAddon owner) {
        super(owner);
        instance = this;
    }

    @Override
    protected void onRun(@Nullable LocalPlayer player) {
        boolean canAutoClimb;
        if (this.freezeMovementTimer > 0) {
            --this.freezeMovementTimer;
            return;
        }
        PoseDataImpl preTickPose = ClientContext.player.getPoseData(PoseDataType.PRE_TICK);
        Vector3fc origin = ClientContext.player.getOrigin();
        float worldScale = ClientContext.player.getWorldScale();
        Vector3f headPivot = preTickPose.createNewHeadPivot(origin, worldScale);
        float playerHalfWidth = player.m_20205_() / 2.0f;
        float playerHeight = player.m_20206_();
        double playerPosY = player.m_20186_();
        AABB collisionBox = new AABB((double)(headPivot.x - playerHalfWidth), playerPosY, (double)(headPivot.z - playerHalfWidth), (double)(headPivot.x + playerHalfWidth), playerPosY + (double)playerHeight, (double)(headPivot.z + playerHalfWidth));
        if (VisorClientImpl.MC.f_91073_.m_45756_((Entity)player, collisionBox)) {
            player.m_20343_((double)headPivot.x, player.m_20186_(), (double)headPivot.z);
            player.m_20011_(collisionBox);
            player.f_19789_ = 0.0f;
            return;
        }
        boolean bl = canAutoClimb = VRClientSettings.isWalkUpEnabled() && ((LocalPlayerModified)player).visor$getJumpFactor() == 1.0f;
        if (canAutoClimb && player.f_19789_ == 0.0f) {
            Vec3 torso = new Vec3((double)headPivot.x, playerPosY, (double)headPivot.z);
            float climbShrink = player.m_6972_((Pose)player.m_20089_()).f_20377_ * 0.45f;
            double shrunkClimbHalfWidth = playerHalfWidth - climbShrink;
            AABB collisionBoxClimb = new AABB(torso.f_82479_ - shrunkClimbHalfWidth, collisionBox.f_82289_, torso.f_82481_ - shrunkClimbHalfWidth, torso.f_82479_ + shrunkClimbHalfWidth, collisionBox.f_82292_, torso.f_82481_ + shrunkClimbHalfWidth);
            if (VisorClientImpl.MC.f_91073_.m_45756_((Entity)player, collisionBoxClimb)) {
                return;
            }
            for (int i = 0; i <= 10; ++i) {
                if (!VisorClientImpl.MC.f_91073_.m_45756_((Entity)player, collisionBox = collisionBox.m_82386_(0.0, 0.1, 0.0))) continue;
                player.m_20343_((double)headPivot.x, collisionBox.f_82289_, (double)headPivot.z);
                player.m_20011_(collisionBox);
                Vector3f newRoomOrigin = origin.add(0.0f, 0.1f * (float)(i + 1), 0.0f, new Vector3f());
                ClientContext.player.setOrigin(newRoomOrigin.x, newRoomOrigin.y, newRoomOrigin.z, false);
                player.f_19789_ = 0.0f;
                ((LocalPlayerModified)VisorClientImpl.MC.f_91074_).visor$stepSound(BlockPos.m_274446_((Position)player.m_20182_()), player.m_20182_());
                break;
            }
        }
    }

    @Override
    protected void onClear(@Nullable LocalPlayer player) {
    }

    @Override
    public boolean isActive(@Nullable LocalPlayer player) {
        return player != null && !player.m_6144_() && !player.m_5803_() && player.m_6084_() && !ClientContext.player.isMoving();
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public TaskType getType() {
        return TaskType.VR_PLAYER_TICK;
    }

    @Override
    @NotNull
    public ElementPriority getPriority() {
        return ElementPriority.HIGHEST;
    }

    public static TaskRoomMovement getInstance() {
        return instance;
    }
}

