/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.tasks.movement.vehicle;

import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.tasks.RegisterVisorTask;
import me.phoenixra.visor.api.client.tasks.TaskType;
import me.phoenixra.visor.api.client.tasks.VisorTask;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.compatibility.ItemClassifier;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.data.PoseDataImpl;
import me.phoenixra.visor.core.client.data.VRClientPlayerImpl;
import me.phoenixra.visor.core.client.tasks.movement.TaskRoomSneak;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@RegisterVisorTask
public class TaskRoomVehicle
extends VisorTask {
    private static final String ID = "room_vehicle";
    private static TaskRoomVehicle instance;
    public Vec3 premountPosRoom = new Vec3(0.0, 0.0, 0.0);
    public float vehicleRotation = 0.0f;
    public int rotationCooldown = 0;
    private int minecartTimer;
    public int dismountDelay = 0;

    public TaskRoomVehicle(@NotNull VisorAddon owner) {
        super(owner);
        instance = this;
    }

    @Override
    protected void onRun(LocalPlayer player) {
        LocalPlayer mcPlayer;
        if (this.canAutoDismount(player)) {
            Vector3f mountPos = player.m_20202_().m_20182_().m_252839_();
            Vector3fc headPivot = ClientContext.player.getPoseData(PoseDataType.PRE_TICK).getHeadPivot();
            double distance = Math.sqrt((headPivot.x() - mountPos.x()) * (headPivot.x() - mountPos.x()) + (headPivot.z() - mountPos.z()) * (headPivot.z() - mountPos.z()));
            if (distance > 0.7 && TaskRoomSneak.getInstance().getSneakTimer() == 0) {
                TaskRoomSneak.getInstance().setSneakTimer(5);
            }
        }
        if (this.dismountDelay > 0) {
            --this.dismountDelay;
        }
        if (this.rotationCooldown > 0) {
            --this.rotationCooldown;
        }
        if (!(mcPlayer = VisorClientImpl.MC.f_91074_).m_20159_() || this.rotationCooldown != 0) {
            this.minecartTimer = 3;
            if (mcPlayer.m_20159_()) {
                this.vehicleRotation = mcPlayer.m_20202_().m_146908_();
            }
            return;
        }
        Entity vehicle = mcPlayer.m_20202_();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)vehicle;
        if (this.shouldMinecartTurnView(minecart)) {
            if (this.minecartTimer > 0) {
                --this.minecartTimer;
            }
        } else {
            this.minecartTimer = 3;
        }
        double rotationTarget = this.getMinecartRenderYaw(minecart);
        if (this.minecartTimer > 0) {
            this.vehicleRotation = (float)rotationTarget;
        }
        Vec3 deltaMovement = vehicle.m_20184_();
        double horizontalSpeed = new Vec3(deltaMovement.f_82479_, 0.0, deltaMovement.f_82481_).m_82553_();
        float smoothed = 200.0f * (float)(horizontalSpeed * horizontalSpeed);
        smoothed = Math.max(smoothed, 10.0f);
        VRClientPlayerImpl vrClientPlayer = ClientContext.player;
        float rotateTo = this.rotationDelta((float)rotationTarget, this.vehicleRotation);
        smoothed = (float)Math.toRadians(smoothed);
        rotateTo = Math.min(smoothed, Math.max(rotateTo, -smoothed));
        vrClientPlayer.setRotationY(vrClientPlayer.getRotationY() + rotateTo);
        this.vehicleRotation = (this.vehicleRotation - rotateTo) % 360.0f;
    }

    @Override
    protected void onClear(LocalPlayer player) {
        this.minecartTimer = 2;
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (VisorClientImpl.MC.m_91104_()) {
            return false;
        }
        if (p == null || VisorClientImpl.MC.f_91072_ == null) {
            return false;
        }
        return p.m_6084_();
    }

    public void onStartRiding(Entity vehicle) {
        VRClientPlayerImpl vrClientPlayer = ClientContext.player;
        PoseDataImpl preTickPose = vrClientPlayer.getPoseData(PoseDataType.PRE_TICK);
        Vector3fc headPivot = vrClientPlayer.getPoseData(PoseDataType.ROOM).getHeadPivot();
        this.premountPosRoom = new Vec3((double)headPivot.x(), 0.0, (double)headPivot.z());
        this.dismountDelay = 5;
        float hmdYaw = preTickPose.getHmd().getYaw();
        float vehicleYRotation = vehicle.m_146908_() % 360.0f;
        this.vehicleRotation = vrClientPlayer.getRotationY();
        this.rotationCooldown = 2;
        if (vehicle instanceof Minecart) {
            return;
        }
        float rotationDelta = this.rotationDelta(vehicleYRotation, hmdYaw);
        vrClientPlayer.setRotationY(preTickPose.getRotationY() + rotationDelta);
    }

    public void onStopRiding() {
        TaskRoomSneak.getInstance().setSneakTimer(0);
    }

    private float getMinecartRenderYaw(Minecart minecart) {
        Vec3 delta = new Vec3(minecart.m_20185_() - minecart.f_19790_, minecart.m_20186_() - minecart.f_19791_, minecart.m_20189_() - minecart.f_19792_);
        float yaw = (float)Math.toDegrees(Mth.m_14136_((double)(-delta.f_82479_), (double)delta.f_82481_));
        return this.shouldMinecartTurnView(minecart) ? -180.0f + yaw : this.vehicleRotation;
    }

    private boolean shouldMinecartTurnView(Minecart minecart) {
        Vec3 delta = new Vec3(minecart.m_20185_() - minecart.f_19790_, minecart.m_20186_() - minecart.f_19791_, minecart.m_20189_() - minecart.f_19792_);
        return delta.m_82553_() > 0.001;
    }

    public boolean canAutoDismount(LocalPlayer player) {
        return player.f_20902_ == 0.0f && player.f_20900_ == 0.0f && player.m_20159_() && this.dismountDelay == 0;
    }

    public static Vector3fc getVehicleLookDirection(LocalPlayer player) {
        Mob mob;
        Entity entity = player.m_20202_();
        if (entity instanceof AbstractHorse || entity instanceof Boat) {
            if (player.f_20902_ <= 0.0f) {
                return null;
            }
            return ClientContext.player.getRotationElement(PoseDataType.PRE_TICK).getDirection();
        }
        if (entity instanceof Mob && (mob = (Mob)entity).m_6109_()) {
            ControllerHand handWithFood = ItemClassifier.FOOD_STICK.is(player.m_21205_().m_41720_()) ? ControllerHand.MAIN : ControllerHand.OFFHAND;
            PoseElement handPose = ClientContext.player.getPoseData(PoseDataType.PRE_TICK).getController(handWithFood);
            return handPose.getDirection().normalize(new Vector3f());
        }
        return null;
    }

    private float rotationDelta(float start, float end) {
        float radiansEnd = (float)Math.toRadians(end);
        float radiansStart = (float)Math.toRadians(start);
        return (float)Mth.m_14136_((double)Mth.m_14031_((float)(radiansEnd - radiansStart)), (double)Mth.m_14089_((float)(radiansEnd - radiansStart)));
    }

    @Override
    @NotNull
    public TaskType getType() {
        return TaskType.VR_PLAYER_TICK;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    public static TaskRoomVehicle getInstance() {
        return instance;
    }
}

