/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.client.utils;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Vector2f;

public class ClientUtils {
    public static Vector2f getPlayAreaSize() {
        return new Vector2f(2.0f, 2.0f);
    }

    public static int getCombinedLightWithMin(BlockAndTintGetter lightReader, BlockPos pos, int minLight) {
        int i = LevelRenderer.m_109541_((BlockAndTintGetter)lightReader, (BlockPos)pos);
        int j = i >> 4 & 0xF;
        if (j < minLight) {
            i &= 0xFFFFFF00;
            i |= minLight << 4;
        }
        return i;
    }

    public static void updateKeyMappingState(KeyMapping keyMapping, boolean pressed) {
        if (keyMapping != null) {
            keyMapping.m_7249_(pressed);
            if (pressed) {
                ++keyMapping.f_90818_;
            }
        }
    }

    public static List<String> wrapText(String text, int maxLineLength) {
        String[] paragraphs;
        if (text == null || maxLineLength <= 0) {
            return text == null ? Collections.emptyList() : Collections.singletonList(text);
        }
        ArrayList<String> wrappedLines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\\r?\\n")) {
            if (paragraph.isEmpty()) {
                wrappedLines.add("");
                continue;
            }
            String[] words = paragraph.split("\\s+");
            StringBuilder line = new StringBuilder();
            for (String word : words) {
                if (!line.isEmpty() && line.length() + 1 + word.length() > maxLineLength) {
                    wrappedLines.add(line.toString());
                    line.setLength(0);
                }
                if (!line.isEmpty()) {
                    line.append(' ');
                }
                line.append(word);
            }
            if (line.isEmpty()) continue;
            wrappedLines.add(line.toString());
        }
        return wrappedLines;
    }

    public static int getCombinedLight(BlockAndTintGetter lightReader, BlockPos pos, int minLight) {
        int i = LevelRenderer.m_109541_((BlockAndTintGetter)lightReader, (BlockPos)pos);
        int j = i >> 4 & 0xF;
        if (j < minLight) {
            i &= 0xFFFFFF00;
            i |= minLight << 4;
        }
        return i;
    }

    public static void takeScreenshot(RenderTarget fb) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screenshot.m_92289_((File)minecraft.f_91069_, (RenderTarget)fb, text -> minecraft.execute(() -> minecraft.f_91065_.m_93076_().m_93785_(text)));
    }
}

