/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.common.addon;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.common.addon.AddonManager;
import me.phoenixra.visor.api.common.addon.VisorAddon;
import me.phoenixra.visor.api.common.addon.element.VisorRegistry;
import me.phoenixra.visor.core.common.addon.VisorRegistriesImpl;
import me.phoenixra.visor.core.common.eventbus.VREventBusImpl;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AddonManagerImpl
implements AddonManager {
    private final Logger logger;
    private final Map<String, VisorAddon> addonsMap;
    private VisorRegistriesImpl registries;

    public AddonManagerImpl(Logger logger) {
        VisorAPI.Instance.setAddonManager(this);
        VisorAPI.Instance.setEventBus(new VREventBusImpl());
        this.logger = logger;
        this.addonsMap = new LinkedHashMap<String, VisorAddon>();
    }

    public void initialize(VisorAddon coreAddon, List<VisorRegistry<?>> elementRegistries) {
        this.registries = new VisorRegistriesImpl(elementRegistries);
        this.addonsMap.put(coreAddon.getAddonId(), coreAddon);
        this.loadAddon(coreAddon);
        for (VisorAddon addon : VisorAPI.Instance.getPreparedAddons().values()) {
            this.addonsMap.put(addon.getAddonId(), addon);
            this.loadAddon(addon);
        }
    }

    private void loadAddon(VisorAddon addon) {
        this.logger.info("----- LOADING Visor Addon with ID: {}", (Object)addon.getAddonId());
        if (addon.getAddonPackagePath() != null) {
            for (VisorRegistry<?> registry : this.registries.list) {
                registry.registerAddonPath(addon);
            }
        }
        addon.onAddonLoad();
        this.logger.info("----- SUCCESS LOADING");
    }

    @Override
    @NotNull
    public VisorAddon getAddon(@NotNull String id) {
        return this.addonsMap.get(id);
    }

    @Override
    @NotNull
    public Collection<VisorAddon> getAddons() {
        return this.addonsMap.values();
    }

    @Override
    public VisorRegistriesImpl getRegistries() {
        return this.registries;
    }
}

