/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.server;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import me.phoenixra.atumconfig.api.ConfigManager;
import me.phoenixra.atumconfig.api.config.Config;
import me.phoenixra.atumconfig.api.config.ConfigFile;
import me.phoenixra.atumconfig.api.config.ConfigType;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.server.SendSettingToClient;
import me.phoenixra.visor.api.server.VRServerSettings;

public class ServerConfig {
    protected static ServerConfig INSTANCE;
    private ConfigFile config;
    private Config configForClients;

    public ServerConfig() {
        INSTANCE = this;
    }

    public void init() throws Throwable {
        this.config = VisorAPI.server().getConfigManager().createConfigFile(ConfigType.YAML, "server_settings", Path.of("server_settings.yml", new String[0]), false);
        ServerConfig.updateServerSettings(this.config);
    }

    public static void updateServerSettings(ConfigManager configManager, String configString) {
        Config config = configManager.createConfigFromString(ConfigType.YAML, configString);
        ServerConfig.updateServerSettings(config);
    }

    public static void updateServerSettings(Config config) {
        try {
            Class<VRServerSettings> clazz = VRServerSettings.class;
            for (Field field : clazz.getDeclaredFields()) {
                String fieldName;
                Object value;
                if (!Modifier.isStatic(field.getModifiers()) || (value = config.get(fieldName = field.getName())) == null) continue;
                field.setAccessible(true);
                if (field.getType().isEnum()) {
                    Class<?> enumType = field.getType();
                    Object enumValue = Enum.valueOf(enumType, value.toString());
                    field.set(null, enumValue);
                }
                if (field.getType().isAssignableFrom(value.getClass())) {
                    field.set(null, value);
                    continue;
                }
                if (field.getType() == Boolean.TYPE && value instanceof Boolean) {
                    field.setBoolean(null, (Boolean)value);
                    continue;
                }
                if (field.getType() == Byte.TYPE && value instanceof Number) {
                    field.setLong(null, ((Number)value).byteValue());
                    continue;
                }
                if (field.getType() == Short.TYPE && value instanceof Number) {
                    field.setLong(null, ((Number)value).shortValue());
                    continue;
                }
                if (field.getType() == Integer.TYPE && value instanceof Number) {
                    field.setLong(null, ((Number)value).intValue());
                    continue;
                }
                if (field.getType() == Long.TYPE && value instanceof Number) {
                    field.setLong(null, ((Number)value).longValue());
                    continue;
                }
                if (field.getType() == Float.TYPE && value instanceof Number) {
                    field.setDouble(null, ((Number)value).floatValue());
                    continue;
                }
                if (field.getType() != Double.TYPE || !(value instanceof Number)) continue;
                field.setDouble(null, ((Number)value).doubleValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Config getSettingsForClient() {
        if (ServerConfig.INSTANCE.configForClients != null) {
            return ServerConfig.INSTANCE.configForClients;
        }
        try {
            ServerConfig.INSTANCE.configForClients = VisorAPI.server().getConfigManager().createConfig(ConfigType.YAML, null);
            Class<VRServerSettings> clazz = VRServerSettings.class;
            for (Field field : clazz.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                if (!field.isAnnotationPresent(SendSettingToClient.class)) continue;
                String fieldName = field.getName();
                Object value = field.get(null);
                if (value == null) continue;
                if (field.getType().isEnum()) {
                    value = value.toString();
                }
                ServerConfig.INSTANCE.configForClients.set(fieldName, value);
            }
            return ServerConfig.INSTANCE.configForClients;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

