/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.server;

import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.common.network.buffer.DevicePoseBuffer;
import me.phoenixra.visor.api.common.network.buffer.PlayerPoseBuffer;
import me.phoenixra.visor.api.common.utils.VRMathUtils;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VRServerPlayerImpl
implements VRServerPlayer {
    public ServerPlayer mcPlayer;
    @Nullable
    private PlayerPoseBuffer playerPoseBuffer;
    public Vector3f offset = new Vector3f(0.0f, 0.0f, 0.0f);
    public int networkVersion = 1;
    public float worldScale = 1.0f;
    public float heightScale = 1.0f;
    public float bowTension;
    public boolean crawling;
    private boolean vr = false;

    public VRServerPlayerImpl(ServerPlayer player) {
        this.mcPlayer = player;
    }

    @Override
    @NotNull
    public Vec3 getControllerVectorCustom(@NotNull ControllerHand controller, @NotNull Vector3fc direction) {
        DevicePoseBuffer controllerPose;
        DevicePoseBuffer devicePoseBuffer = controllerPose = controller == ControllerHand.MAIN ? this.playerPoseBuffer.mainHand() : this.playerPoseBuffer.offhand();
        if (controllerPose != null) {
            Vector3f vector3 = controllerPose.orientation().transform(direction, new Vector3f());
            return new Vec3((double)vector3.x(), (double)vector3.y(), (double)vector3.z());
        }
        return this.mcPlayer.m_20154_();
    }

    @Override
    @NotNull
    public Vec3 getControllerDir(@NotNull ControllerHand controller) {
        return this.getControllerVectorCustom(controller, VRMathUtils.BACK_VECTOR);
    }

    @Override
    @NotNull
    public Vec3 getHmdDir() {
        if (this.playerPoseBuffer != null) {
            Vector3f vector3 = this.playerPoseBuffer.hmd().orientation().transform(VRMathUtils.BACK_VECTOR, new Vector3f());
            return new Vec3((double)vector3.x(), (double)vector3.y(), (double)vector3.z());
        }
        return this.mcPlayer.m_20154_();
    }

    @Override
    @NotNull
    public Vec3 getHmdPos(@NotNull Player player) {
        if (this.playerPoseBuffer != null) {
            return new Vec3(this.playerPoseBuffer.hmd().position().add((Vector3fc)player.m_20182_().m_252839_(), new Vector3f()).add((Vector3fc)this.offset));
        }
        return player.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    @Override
    @NotNull
    public Vec3 getControllerPos(@NotNull ControllerHand controller) {
        if (this.playerPoseBuffer != null) {
            DevicePoseBuffer controllerState = controller == ControllerHand.MAIN ? this.playerPoseBuffer.mainHand() : this.playerPoseBuffer.offhand();
            return new Vec3(controllerState.position().add((Vector3fc)this.mcPlayer.m_20182_().m_252839_(), new Vector3f()).add((Vector3fc)this.offset));
        }
        return this.mcPlayer.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    @Override
    public ServerPlayer getMcPlayer() {
        return this.mcPlayer;
    }

    @Nullable
    public PlayerPoseBuffer getPlayerPoseBuffer() {
        return this.playerPoseBuffer;
    }

    public void setPlayerPoseBuffer(@Nullable PlayerPoseBuffer playerPoseBuffer) {
        this.playerPoseBuffer = playerPoseBuffer;
    }

    @Override
    public float getHeightScale() {
        return this.heightScale;
    }

    @Override
    public float getBowTension() {
        return this.bowTension;
    }

    @Override
    public boolean isCrawling() {
        return this.crawling;
    }

    @Override
    public boolean isVr() {
        return this.vr;
    }

    public void setVr(boolean vr) {
        this.vr = vr;
    }
}

