/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.core.server.network;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.common.network.toclient.VisorPayloadToClient;
import me.phoenixra.visor.api.common.network.toclient.vrstate.VRStatePayloadToClient;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.server.VRServerPlayerImpl;
import me.phoenixra.visor.core.server.VisorServerImpl;
import me.phoenixra.visor.mixin.common.accessors.ChunkMapAccessor;
import me.phoenixra.visor.mixin.common.accessors.TrackedEntityAccessor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Pose;

public class ServerNetworking {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static void sendVRPacketTo(VRServerPlayer vrServerPlayer, VisorPayloadToClient payload) {
        if (VisorClientImpl.MC.m_91403_() == null) {
            return;
        }
        vrServerPlayer.getMcPlayer().f_8906_.m_9829_(ServerNetworking.createVRPacket(payload));
    }

    public static Packet<?> createVRPacket(VisorPayloadToClient payload) {
        return ModLoader.get().createPacketToClient(payload);
    }

    public static void kickDelayedNoVR(ServerPlayer serverPlayer) {
        scheduler.schedule(() -> {
            if (serverPlayer.m_9232_()) {
                return;
            }
            VRServerPlayer vrServerPlayer = VisorAPI.server().getVrPlayer(serverPlayer);
            if (serverPlayer.f_8924_.m_6846_().m_11303_(serverPlayer.m_36316_())) {
                return;
            }
            if (vrServerPlayer == null || !vrServerPlayer.isVr()) {
                serverPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"Server For VR player only!"));
            }
        }, 10000L, TimeUnit.MILLISECONDS);
    }

    public static void updatePlayerPose(ServerPlayer player) {
        VRServerPlayer vrServerPlayer = VisorAPI.server().getVrPlayer(player);
        if (vrServerPlayer != null && vrServerPlayer.isVr() && vrServerPlayer.isCrawling()) {
            player.m_20124_(Pose.SWIMMING);
        }
    }

    public static void sendVRStateToOthers(ServerPlayer serverPlayer) {
        Map<UUID, VRServerPlayer> playersWithVR = VisorServerImpl.INSTANCE.getPlayersWithVR();
        VRServerPlayerImpl vrServerPlayer = (VRServerPlayerImpl)playersWithVR.get(serverPlayer.m_20148_());
        if (vrServerPlayer == null) {
            return;
        }
        if (vrServerPlayer.mcPlayer == null || vrServerPlayer.mcPlayer.m_9232_()) {
            playersWithVR.remove(serverPlayer.m_20148_());
        }
        if (!vrServerPlayer.isVr() || vrServerPlayer.getPlayerPoseBuffer() == null) {
            return;
        }
        ServerNetworking.sendPacketToTrackedPlayers(vrServerPlayer, false, new VRStatePayloadToClient(vrServerPlayer.mcPlayer.m_20148_(), vrServerPlayer.getPlayerPoseBuffer(), vrServerPlayer.worldScale, vrServerPlayer.heightScale));
    }

    public static void sendPacketToTrackedPlayers(VRServerPlayer packetOwner, boolean sendToOwner, VisorPayloadToClient payload) {
        Packet<?> packet = ModLoader.get().createPacketToClient(payload);
        Map<UUID, VRServerPlayer> vrPlayers = VisorServerImpl.INSTANCE.getPlayersWithVR();
        for (ServerPlayerConnection players : ServerNetworking.getTrackedPlayers(packetOwner.getMcPlayer())) {
            boolean isPacketOwner;
            boolean hasVisor = vrPlayers.containsKey(players.m_142253_().m_20148_());
            boolean bl = isPacketOwner = players.m_142253_() == packetOwner.getMcPlayer();
            if (!hasVisor || isPacketOwner) continue;
            players.m_9829_(packet);
        }
        if (sendToOwner) {
            packetOwner.getMcPlayer().f_8906_.m_9829_(packet);
        }
    }

    public static Set<ServerPlayerConnection> getTrackedPlayers(ServerPlayer player) {
        ChunkMap chunkMap = player.m_284548_().m_7726_().f_8325_;
        TrackedEntityAccessor entityAccessor = (TrackedEntityAccessor)((ChunkMapAccessor)chunkMap).getTrackedEntities().get(player.m_19879_());
        return entityAccessor != null ? Collections.unmodifiableSet(entityAccessor.getPlayersTracking()) : Collections.emptySet();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(scheduler::shutdownNow));
    }
}

