/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.loader.forge;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.common.network.toclient.VisorPayloadToClient;
import me.phoenixra.visor.api.common.network.toserver.VisorPayloadToServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ForgeModLoader
implements ModLoader {
    private File configFolder = FMLPaths.CONFIGDIR.get().toFile();

    @Override
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Override
    @NotNull
    public String getId() {
        return "forge";
    }

    @Override
    public boolean isModLoaded(@NotNull String id) {
        return FMLLoader.getLoadingModList().getModFileById(id) != null;
    }

    @Override
    @NotNull
    public String getModVersion(@NotNull String id) {
        if (this.isModLoaded("visor")) {
            return FMLLoader.getLoadingModList().getModFileById(id).versionString();
        }
        return "no version";
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    @Override
    public boolean enableRenderTargetStencil(@NotNull RenderTarget renderTarget) {
        renderTarget.enableStencil();
        return true;
    }

    @Override
    public double getItemEntityReach(double baseRange, ItemStack itemStack, EquipmentSlot slot) {
        Collection attributes = itemStack.m_41638_(slot).get((Object)((Attribute)ForgeMod.ENTITY_REACH.get()));
        for (AttributeModifier entry : attributes) {
            if (entry.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            baseRange += entry.m_22218_();
        }
        double totalRange = baseRange;
        for (AttributeModifier entry : attributes) {
            if (entry.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            totalRange += baseRange * entry.m_22218_();
        }
        for (AttributeModifier entry : attributes) {
            if (entry.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            totalRange *= 1.0 + entry.m_22218_();
        }
        return totalRange;
    }

    @Override
    @NotNull
    public List<Class<?>> getClassesAnnotated(@NotNull Class<? extends Annotation> annotation, @NotNull String modId, @NotNull String packagePath) {
        ArrayList result = new ArrayList();
        IModFileInfo info = ModList.get().getModFileById(modId);
        if (!(info instanceof ModFileInfo)) {
            return result;
        }
        ModFileInfo modFileInfo = (ModFileInfo)info;
        ModFileScanData scanData = modFileInfo.getFile().getScanResult();
        String annotationName = annotation.getName();
        for (ModFileScanData.AnnotationData annotationData : scanData.getAnnotations()) {
            String className = annotationData.clazz().getClassName();
            if (!className.startsWith(packagePath) || !annotationData.annotationType().getClassName().equals(annotationName)) continue;
            try {
                Class<?> cls = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                result.add(cls);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Packet<?> createPacketToClient(@NotNull VisorPayloadToClient payload) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        payload.write(buffer);
        return NetworkDirection.PLAY_TO_CLIENT.buildPacket((Pair)new ImmutablePair((Object)buffer, (Object)0), payload.id()).getThis();
    }

    @Override
    @NotNull
    public Packet<?> createPacketToServer(@NotNull VisorPayloadToServer payload) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        payload.write(buffer);
        return NetworkDirection.PLAY_TO_SERVER.buildPacket((Pair)new ImmutablePair((Object)buffer, (Object)0), payload.id()).getThis();
    }

    @Override
    public boolean renderBlockOverlay(Player player, PoseStack mat, BlockState state, BlockPos pos) {
        return ForgeHooksClient.renderBlockOverlay((Player)player, (PoseStack)mat, (RenderBlockScreenEffectEvent.OverlayType)RenderBlockScreenEffectEvent.OverlayType.BLOCK, (BlockState)state, (BlockPos)pos);
    }

    @Override
    public boolean renderWaterOverlay(Player player, PoseStack mat) {
        return ForgeHooksClient.renderWaterOverlay((Player)player, (PoseStack)mat);
    }

    @Override
    public boolean renderFireOverlay(Player player, PoseStack mat) {
        return ForgeHooksClient.renderFireOverlay((Player)player, (PoseStack)mat);
    }
}

