/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.loader.forge;

import me.phoenixra.visor.api.ModLoader;
import me.phoenixra.visor.api.common.network.VisorNetwork;
import me.phoenixra.visor.api.common.network.toclient.VisorPayloadToClient;
import me.phoenixra.visor.api.common.network.toserver.VisorPayloadToServer;
import me.phoenixra.visor.core.client.network.ClientPacketHandler;
import me.phoenixra.visor.core.server.network.ServerPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;

@Mod(value="visor")
public class VisorMod {
    public static final EventNetworkChannel NETWORK_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)VisorNetwork.CHANNEL).clientAcceptedVersions(status -> true).serverAcceptedVersions(status -> true).networkProtocolVersion(() -> "0").eventNetworkChannel();

    public VisorMod() {
        NETWORK_CHANNEL.addListener(event -> {
            if (event.getPayload() != null) {
                if (((NetworkEvent.Context)event.getSource().get()).getDirection().getOriginationSide().isClient()) {
                    VisorMod.handleServerPacket(event.getPayload(), (NetworkEvent.Context)event.getSource().get());
                } else {
                    VisorMod.handleClientPacket(event.getPayload(), (NetworkEvent.Context)event.getSource().get());
                }
            }
            ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
        });
    }

    private static void handleClientPacket(FriendlyByteBuf buffer, NetworkEvent.Context context) {
        VisorPayloadToClient packet = VisorPayloadToClient.readPacket(buffer);
        context.enqueueWork(() -> ClientPacketHandler.handlePacket(packet));
    }

    private static void handleServerPacket(FriendlyByteBuf buffer, NetworkEvent.Context context) {
        VisorPayloadToServer packet = VisorPayloadToServer.readPacket(buffer);
        context.enqueueWork(() -> ServerPacketHandler.handlePacket(packet, context.getSender(), p -> context.getNetworkManager().m_129512_(ModLoader.get().createPacketToClient((VisorPayloadToClient)p))));
    }
}

