/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.client.player;

import com.mojang.authlib.GameProfile;
import me.phoenixra.visor.api.client.data.PoseDataType;
import me.phoenixra.visor.api.client.data.PoseElement;
import me.phoenixra.visor.api.client.input.HandAction;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.core.client.ClientContext;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.render.helpers.RenderPoseHelper;
import me.phoenixra.visor.core.client.settings.VRClientSettings;
import me.phoenixra.visor.core.client.tasks.movement.vehicle.TaskRoomVehicle;
import me.phoenixra.visor.modified.client.entity.LocalPlayerModified;
import me.phoenixra.visor.modified.client.render.ItemInHandRendererModified;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer
implements LocalPlayerModified {
    @Final
    @Shadow
    protected Minecraft f_108619_;
    @Shadow
    private boolean f_108609_;
    @Shadow
    @Final
    public ClientPacketListener f_108617_;
    @Shadow
    private InteractionHand f_108610_;
    @Unique
    private Vec3 visor$moveMulIn = Vec3.f_82478_;
    @Unique
    private boolean visor$initialized;
    @Unique
    private boolean visor$walkUpBlocksActive = false;

    public LocalPlayerMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Shadow
    protected abstract void m_108743_(float var1, float var2);

    @Shadow
    public abstract void m_6674_(InteractionHand var1);

    @Inject(at={@At(value="TAIL")}, method={"startRiding"})
    public void visor$onStartRiding(Entity entity, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            return;
        }
        TaskRoomVehicle.getInstance().onStartRiding(entity);
    }

    @Inject(at={@At(value="TAIL")}, method={"removeVehicle"})
    public void visor$onStopRiding(CallbackInfo ci) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            return;
        }
        TaskRoomVehicle.getInstance().onStopRiding();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V", shift=At.Shift.BEFORE)}, method={"tick"})
    public void visor$preTick(CallbackInfo ci) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            return;
        }
        ClientContext.player.updatePlayerLook((LocalPlayer)this, PoseDataType.PRE_TICK);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V", shift=At.Shift.AFTER)}, method={"tick"})
    public void visor$postTick(CallbackInfo ci) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            return;
        }
        ClientContext.player.updatePlayerLook((LocalPlayer)this, PoseDataType.PRE_TICK);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;aiStep()V")}, method={"aiStep"})
    public void visor$tickPlayer(CallbackInfo ci) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this) || !this.visor$initialized) {
            return;
        }
        ClientContext.player.tickPlayer((LocalPlayer)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"move"}, cancellable=true)
    public void visor$onMove(MoverType type, Vec3 pos, CallbackInfo info) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this) || Minecraft.m_91087_().m_91288_() != this) {
            if (this.visor$walkUpBlocksActive) {
                this.m_274367_(0.6f);
                this.visor$walkUpBlocksActive = false;
            }
            return;
        }
        info.cancel();
        this.visor$moveMulIn = this.f_19865_;
        if (pos.m_82553_() == 0.0 || this.m_20159_()) {
            super.m_6478_(type, pos);
            return;
        }
        boolean canMoveY = true;
        Vector3fc origin = ClientContext.player.getOrigin();
        if (this.f_20902_ != 0.0f || this.m_21255_() || Math.abs(this.m_20184_().f_82479_) > 0.0095 || Math.abs(this.m_20184_().f_82481_) > 0.0095) {
            double xOffset = (double)origin.x() - this.m_20185_();
            double zOffset = (double)origin.z() - this.m_20189_();
            double prevX = this.m_20185_();
            double prevZ = this.m_20189_();
            super.m_6478_(type, pos);
            if (VRClientSettings.isWalkUpEnabled()) {
                this.m_274367_(this.m_20098_() == 1.0f ? 1.0f : 0.6f);
                this.visor$walkUpBlocksActive = this.m_20098_() == 1.0f;
            } else {
                if (this.visor$walkUpBlocksActive) {
                    this.m_274367_(0.6f);
                    this.visor$walkUpBlocksActive = false;
                }
                this.m_108743_((float)(this.m_20185_() - prevX), (float)(this.m_20189_() - prevZ));
            }
            ClientContext.player.setOrigin((float)(this.m_20185_() + xOffset), (float)(this.m_20186_() + this.visor$getRoomYOffset()), (float)(this.m_20189_() + zOffset), false);
            return;
        }
        if (canMoveY) {
            super.m_6478_(type, new Vec3(0.0, pos.f_82480_, 0.0));
            ClientContext.player.setOrigin(origin.x(), (float)(this.m_20186_() + this.visor$getRoomYOffset()), origin.z(), false);
            return;
        }
        this.m_6853_(true);
    }

    public void m_19920_(float inputStrength, @NotNull Vec3 relative) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            super.m_19920_(inputStrength, relative);
            return;
        }
        double speed = relative.f_82479_ * relative.f_82479_ + relative.f_82481_ * relative.f_82481_;
        if (speed < 5.0E-4) {
            return;
        }
        speed = Math.max(1.0, Math.sqrt(speed));
        speed = (double)inputStrength / speed;
        Vec3 move = new Vec3(relative.f_82479_ * speed, 0.0, relative.f_82481_ * speed);
        PoseElement rotationElement = ClientContext.player.getRotationElement(PoseDataType.PRE_TICK);
        if (!this.m_20159_() && (this.m_6069_() || this.m_150110_().f_35935_)) {
            move = move.m_82496_(rotationElement.getPitch() * ((float)Math.PI / 180));
        }
        move = move.m_82524_(rotationElement.getYaw() * ((float)Math.PI / 180) * -1.0f);
        float yFactor = this.m_150110_().f_35935_ ? 5.0f : 1.0f;
        this.m_20334_(this.m_20184_().f_82479_ + move.f_82479_, this.m_20184_().f_82480_ + move.f_82480_ * (double)yFactor, this.m_20184_().f_82481_ + move.f_82481_);
    }

    public void m_19890_(double x, double e, double y, float g, float z) {
        super.m_19890_(x, e, y, g, z);
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            return;
        }
        ClientContext.player.recenterOrigin((Entity)((LocalPlayer)this), false);
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;lastOnGround:Z", shift=At.Shift.AFTER, ordinal=1)}, method={"sendPosition"})
    public void visor$walkUp(CallbackInfo ci) {
        if (VisorState.getState().isNotActive() || !VRClientSettings.isWalkUpEnabled()) {
            return;
        }
        this.f_108619_.f_91066_.m_231812_().m_231514_((Object)false);
    }

    public void m_6034_(double posX, double posY, double posZ) {
        boolean shouldReset;
        this.visor$initialized = true;
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            super.m_6034_(posX, posY, posZ);
            return;
        }
        super.m_6034_(posX, posY, posZ);
        boolean bl = shouldReset = posX + posY + posZ == 0.0;
        if (this.m_20159_()) {
            Vec3 premountPos = TaskRoomVehicle.getInstance().premountPosRoom;
            premountPos = premountPos.m_82524_(ClientContext.player.getPoseData(PoseDataType.PRE_TICK).getRotationY());
            ClientContext.player.setOrigin((float)(posX -= premountPos.f_82479_), (float)posY, (float)(posZ -= premountPos.f_82481_), shouldReset);
            return;
        }
        ClientContext.player.recenterOrigin((Entity)((LocalPlayer)this), shouldReset);
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;sin(F)F"), method={"updateAutoJump"})
    private float visor$vrAutoJumpSin(float original) {
        return VisorState.getState().isActive() ? ClientContext.player.getPoseData(PoseDataType.PRE_TICK).getBodyYaw() : original;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;cos(F)F"), method={"updateAutoJump"})
    private float visor$vrAutoJumpCos(float original) {
        return VisorState.getState().isActive() ? ClientContext.player.getPoseData(PoseDataType.PRE_TICK).getBodyYaw() : original;
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            return;
        }
        ClientContext.inputManager.triggerHapticPulseBoth(2.0f);
    }

    @Inject(method={"getRopeHoldPosition"}, at={@At(value="HEAD")}, cancellable=true)
    private void visor$vrRopePosition(CallbackInfoReturnable<Vec3> cir) {
        if (VisorState.getState().isNotActive() || !this.visor$isLocalPlayer(this)) {
            return;
        }
        cir.setReturnValue((Object)new Vec3((Vector3f)RenderPoseHelper.getControllerPosition(ControllerHand.MAIN)));
    }

    @Override
    @Unique
    public void visor$swingArm(InteractionHand interactionhand, HandAction interact) {
        ((ItemInHandRendererModified)this.f_108619_.m_91290_().m_234586_()).visor$setSwingType(interact);
        this.m_6674_(interactionhand);
    }

    @Override
    @Unique
    public void visor$stepSound(BlockPos blockforNoise, Vec3 soundPos) {
        BlockState blockNoise = this.m_9236_().m_8055_(blockforNoise);
        Block block = blockNoise.m_60734_();
        if (this.m_20067_() || block.m_49966_().m_278721_()) {
            return;
        }
        BlockState blockAboveNoise = this.m_9236_().m_8055_(blockforNoise.m_7494_());
        SoundType soundType = block.m_49962_(blockNoise);
        if (blockAboveNoise.m_60734_() == Blocks.f_50125_) {
            soundType = Blocks.f_50125_.m_49962_(blockAboveNoise);
        }
        SoundEvent soundevent = soundType.m_56776_();
        this.m_9236_().m_6263_(null, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, soundevent, this.m_5720_(), soundType.m_56773_(), soundType.m_56774_());
    }

    @Override
    @Unique
    public void visor$setUsingItem(ItemStack item, InteractionHand hand) {
        this.f_20935_ = item;
        if (item != ItemStack.f_41583_) {
            this.f_108609_ = true;
            this.f_108610_ = hand;
        } else {
            this.f_108609_ = false;
            this.f_108610_ = hand;
        }
    }

    @Override
    @Unique
    public double visor$getRoomYOffset() {
        double out = 0.0;
        if (this.m_20089_() == Pose.SPIN_ATTACK || this.m_20089_() == Pose.FALL_FLYING || this.m_20089_() == Pose.SWIMMING) {
            out = -1.2;
        }
        return out;
    }

    @Override
    @Unique
    public float visor$getJumpFactor() {
        return this.visor$moveMulIn.m_82556_() > 0.0 ? (float)((double)this.m_20098_() * this.visor$moveMulIn.f_82480_) : this.m_20098_();
    }

    @Override
    @Unique
    public void visor$setUseItemRemaining(int count) {
        this.f_20936_ = count;
    }

    @Unique
    private boolean visor$isLocalPlayer(Object player) {
        return player.getClass().equals(LocalPlayer.class) || Minecraft.m_91087_().f_91074_ == player;
    }
}

