/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.client.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.IOException;
import java.util.EnumMap;
import me.phoenixra.visor.api.client.render.VRDisplay;
import me.phoenixra.visor.core.client.VisorState;
import me.phoenixra.visor.core.client.render.VRRenderState;
import me.phoenixra.visor.core.client.render.target.MultiDisplayRenderTarget;
import me.phoenixra.visor.modified.client.render.RenderTargetModified;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PostChain.class})
public class PostChainMixin {
    @Shadow
    @Final
    private RenderTarget f_110006_;
    @Unique
    @Final
    private final EnumMap<VRDisplay, PostChain> visor$vrChains = new EnumMap(VRDisplay.class);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void visor$onInit(TextureManager textureManager, ResourceManager resourceManager, RenderTarget screenTarget, ResourceLocation name, CallbackInfo ci) throws IOException {
        if (VisorState.getState().isNotInitialized() || this.f_110006_ != VRRenderState.getVanillaTarget()) {
            return;
        }
        for (VRDisplay display : VRDisplay.values()) {
            RenderTarget target = VRRenderState.getTargetForDisplay(display);
            if (target == null) continue;
            this.visor$vrChains.put(display, new PostChain(textureManager, resourceManager, target, name));
        }
    }

    @Inject(method={"process"}, at={@At(value="HEAD")}, cancellable=true)
    private void visor$processVRChains(float partialTick, CallbackInfo ci) {
        if (VRRenderState.getCurrentPhase().isNotVRWorld()) {
            return;
        }
        PostChain vrChain = this.visor$vrChains.get((Object)VRRenderState.getCurrentVRDisplay());
        if (vrChain == null) {
            return;
        }
        vrChain.m_110023_(partialTick);
        ci.cancel();
    }

    @Inject(method={"getTempTarget"}, at={@At(value="RETURN")}, cancellable=true)
    private void visor$onGetTempTarget(String attributeName, CallbackInfoReturnable<RenderTarget> cir) {
        if (VisorState.getState().isNotInitialized() || this.visor$vrChains.isEmpty()) {
            return;
        }
        EnumMap<VRDisplay, RenderTarget> vrTempTargets = new EnumMap<VRDisplay, RenderTarget>(VRDisplay.class);
        this.visor$vrChains.forEach((d, pc) -> vrTempTargets.put((VRDisplay)((Object)d), pc.m_110036_(attributeName)));
        cir.setReturnValue((Object)new MultiDisplayRenderTarget((RenderTarget)cir.getReturnValue(), vrTempTargets));
    }

    @ModifyVariable(method={"addTempTarget"}, at=@At(value="STORE"), ordinal=0)
    private RenderTarget visor$tempTargetStencil(RenderTarget renderTarget) {
        if (((RenderTargetModified)this.f_110006_).visor$isUsingStencil()) {
            ((RenderTargetModified)renderTarget).visor$setUseStencil(true);
            renderTarget.m_83941_(renderTarget.f_83915_, renderTarget.f_83916_, Minecraft.f_91002_);
        }
        return renderTarget;
    }

    @Inject(method={"close"}, at={@At(value="TAIL")})
    private void visor$onClose(CallbackInfo ci) {
        this.visor$vrChains.values().forEach(PostChain::close);
        this.visor$vrChains.clear();
    }

    @Inject(method={"resize"}, at={@At(value="TAIL")})
    private void visor$onResize(CallbackInfo ci) {
        this.visor$vrChains.forEach((display, pc) -> {
            RenderTarget target = VRRenderState.getTargetForDisplay(display);
            if (target == null) {
                return;
            }
            pc.m_110025_(target.f_83915_, target.f_83916_);
        });
    }
}

