/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.client.renderer.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import me.phoenixra.visor.core.client.VisorClientImpl;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayerData;
import me.phoenixra.visor.core.client.network.players.VRRemotePlayers;
import me.phoenixra.visor.core.client.render.player.RenderLayerType;
import me.phoenixra.visor.core.client.render.player.VRPlayerRenderer;
import me.phoenixra.visor.core.common.CommonUtils;
import me.phoenixra.visor.modified.client.entity.EntityRenderDispatcherPlayerModified;
import me.phoenixra.visor.modified.client.render.RenderLayerModified;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

public class EntityPlayerRenderMixins {

    @Mixin(value={LivingEntityRenderer.class})
    public static abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>>
    extends EntityRenderer<T> {
        @Shadow
        protected M f_115290_;

        protected LivingEntityRendererMixin(EntityRendererProvider.Context context) {
            super(context);
        }

        @Inject(at={@At(value="HEAD")}, method={"addLayer"})
        public void visor$copyLayer(RenderLayer<T, M> renderLayer, CallbackInfoReturnable<Boolean> cir) {
            if (((Object)((Object)this)).getClass() == PlayerRenderer.class && !((EntityRenderDispatcherPlayerModified)Minecraft.m_91087_().m_91290_()).visor$getSkinMapVR().isEmpty()) {
                Constructor<?> constructor = null;
                RenderLayerType type = RenderLayerType.OTHER;
                for (Constructor<?> c : renderLayer.getClass().getConstructors()) {
                    if (c.getParameterCount() == 1 && RenderLayerParent.class.isAssignableFrom(c.getParameterTypes()[0])) {
                        constructor = c;
                        type = RenderLayerType.PARENT_ONLY;
                        break;
                    }
                    if (c.getParameterCount() == 2 && RenderLayerParent.class.isAssignableFrom(c.getParameterTypes()[0]) && EntityModelSet.class.isAssignableFrom(c.getParameterTypes()[1])) {
                        constructor = c;
                        type = RenderLayerType.PARENT_MODELSET;
                        continue;
                    }
                    if (c.getParameterCount() != 3 || !RenderLayerParent.class.isAssignableFrom(c.getParameterTypes()[0]) || !HumanoidModel.class.isAssignableFrom(c.getParameterTypes()[1]) || !HumanoidModel.class.isAssignableFrom(c.getParameterTypes()[2]) || !(renderLayer instanceof HumanoidArmorLayer)) continue;
                    constructor = c;
                    type = RenderLayerType.PARENT_MODEL_MODEL;
                }
                if (constructor == null) {
                    if (((PlayerModel)this.f_115290_).f_103380_) {
                        this.visor$addLayerClone(renderLayer, (LivingEntityRenderer)((EntityRenderDispatcherPlayerModified)this.f_114476_).visor$getSkinMapVR().get("slim"));
                    } else {
                        this.visor$addLayerClone(renderLayer, (LivingEntityRenderer)((EntityRenderDispatcherPlayerModified)this.f_114476_).visor$getSkinMapVR().get("default"));
                    }
                } else if (((PlayerModel)this.f_115290_).f_103380_) {
                    this.visor$addLayerConstructor(constructor, type, (LivingEntityRenderer)((EntityRenderDispatcherPlayerModified)this.f_114476_).visor$getSkinMapVR().get("slim"));
                } else {
                    this.visor$addLayerConstructor(constructor, type, (LivingEntityRenderer)((EntityRenderDispatcherPlayerModified)this.f_114476_).visor$getSkinMapVR().get("default"));
                }
            }
        }

        @Unique
        private void visor$addLayerClone(RenderLayer<T, M> renderLayer, LivingEntityRenderer<T, M> target) {
            try {
                VisorClientImpl.LOGGER.warn("Copying layer: {} with Object.copy, this could cause issues", renderLayer.getClass());
                RenderLayer newLayer = (RenderLayer)((RenderLayerModified)renderLayer).clone();
                newLayer.f_117344_ = target;
                target.m_115326_(newLayer);
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        @Unique
        private void visor$addLayerConstructor(Constructor<?> constructor, RenderLayerType type, LivingEntityRenderer<T, M> target) {
            try {
                switch (type) {
                    case PARENT_ONLY: {
                        target.m_115326_((RenderLayer)constructor.newInstance(target));
                        break;
                    }
                    case PARENT_MODELSET: {
                        target.m_115326_((RenderLayer)constructor.newInstance(target, Minecraft.m_91087_().m_167973_()));
                        break;
                    }
                    case PARENT_MODEL_MODEL: {
                        if (((PlayerModel)this.f_115290_).f_103380_) {
                            target.m_115326_((RenderLayer)constructor.newInstance(target, new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171167_)), new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171168_))));
                            break;
                        }
                        target.m_115326_((RenderLayer)constructor.newInstance(target, new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_)), new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_))));
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Mixin(value={EntityRenderDispatcher.class})
    public static abstract class EntityRenderDispatcherMixin
    implements ResourceManagerReloadListener,
    EntityRenderDispatcherPlayerModified {
        @Unique
        private final Map<String, VRPlayerRenderer> visor$skinMapVR = new HashMap<String, VRPlayerRenderer>();
        @Unique
        private VRPlayerRenderer visor$playerRendererVR;

        @Override
        public Map<String, VRPlayerRenderer> visor$getSkinMapVR() {
            return this.visor$skinMapVR;
        }

        @Inject(at={@At(value="HEAD")}, method={"renderHitbox"})
        private static void visor$headHitbox(PoseStack poseStack, VertexConsumer vertexConsumer, Entity entity, float f, CallbackInfo ci) {
            AABB headBox = CommonUtils.getEntityHeadHitBox(entity, 0.0);
            if (headBox != null) {
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)headBox.m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_()), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                AABB headBoxArrow = CommonUtils.getEntityHeadHitBox(entity, 0.3);
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (AABB)headBoxArrow.m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_()), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }

        @Inject(at={@At(value="HEAD")}, method={"getRenderer(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/client/renderer/entity/EntityRenderer;"}, cancellable=true)
        public void visor$renderer(Entity pEntity, CallbackInfoReturnable<EntityRenderer<AbstractClientPlayer>> info) {
            if (pEntity instanceof AbstractClientPlayer) {
                String skinId = ((AbstractClientPlayer)pEntity).m_108564_();
                VRRemotePlayerData vrPlayerNetworkData = VRRemotePlayers.getInstance().getPlayer(pEntity.m_20148_());
                if (vrPlayerNetworkData != null) {
                    VRPlayerRenderer playerRenderer = this.visor$skinMapVR.get(skinId);
                    if (playerRenderer == null) {
                        playerRenderer = this.visor$playerRendererVR;
                    }
                    info.setReturnValue((Object)playerRenderer);
                }
            }
        }

        @Inject(at={@At(value="HEAD")}, method={"onResourceManagerReload"})
        public void visor$reloadClear(ResourceManager resourceManager, CallbackInfo ci) {
            this.visor$skinMapVR.clear();
        }

        @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderers;createPlayerRenderers(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)Ljava/util/Map;", shift=At.Shift.AFTER)}, method={"onResourceManagerReload"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
        public void visor$reload(ResourceManager resourceManager, CallbackInfo info, EntityRendererProvider.Context context) {
            this.visor$playerRendererVR = new VRPlayerRenderer(context, false);
            this.visor$skinMapVR.put("default", this.visor$playerRendererVR);
            this.visor$skinMapVR.put("slim", new VRPlayerRenderer(context, true));
        }
    }
}

