/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.common.player;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnItemParticles"}, cancellable=true)
    private void visor$spawnVRItemParticles(ItemStack itemStack, int count, CallbackInfo ci) {
        LivingEntity instance = (LivingEntity)this;
        if (!(instance instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)instance;
        ci.cancel();
        VRServerPlayer serverPlayer = VisorAPI.server().getVrPlayer(player);
        for (int i = 0; i < count; ++i) {
            Vec3 particlePos;
            Vec3 velocity = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            velocity = velocity.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            velocity = velocity.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            double verticalOffset = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
            if (serverPlayer != null && serverPlayer.isVr()) {
                InteractionHand interactionhand = player.m_7655_();
                particlePos = interactionhand == InteractionHand.MAIN_HAND ? serverPlayer.getControllerPos(ControllerHand.MAIN) : serverPlayer.getControllerPos(ControllerHand.OFFHAND);
            } else {
                particlePos = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.3, verticalOffset, 0.6);
                particlePos = particlePos.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                particlePos = particlePos.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                particlePos = particlePos.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            }
            particlePos = particlePos.m_82520_(0.0, -0.8, 0.0);
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, velocity.f_82479_, velocity.f_82480_ + 0.05, velocity.f_82481_, 0.0);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, velocity.f_82479_, velocity.f_82480_ + 0.05, velocity.f_82481_);
        }
    }
}

