/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.common.player;

import com.mojang.authlib.GameProfile;
import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.server.VRServerSettings;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import me.phoenixra.visor.core.server.network.ServerNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    @Final
    public MinecraftServer f_8924_;

    public ServerPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;tick()V", shift=At.Shift.AFTER)}, method={"doTick()V"})
    public void visor$tick(CallbackInfo info) {
        ServerNetworking.updatePlayerPose((ServerPlayer)this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", shift=At.Shift.BEFORE)}, method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void visor$vrItemDrop(ItemStack itemStack, boolean dropAround, boolean includeName, CallbackInfoReturnable<ItemEntity> info, ItemEntity itemEntity) {
        VRServerPlayer serverPlayer = this.visor$getVrPlayer();
        if (serverPlayer == null || !serverPlayer.isVr() || dropAround) {
            return;
        }
        Vec3 handDir = serverPlayer.getControllerDir(ControllerHand.MAIN).m_82490_((double)0.3f);
        Vec3 handPos = serverPlayer.getControllerPos(ControllerHand.MAIN);
        itemEntity.m_20334_(handDir.f_82479_, handDir.f_82480_, handDir.f_82481_);
        itemEntity.m_6034_(handPos.m_7096_() + itemEntity.m_20184_().m_7096_(), handPos.m_7098_() + itemEntity.m_20184_().m_7098_(), handPos.m_7094_() + itemEntity.m_20184_().m_7094_());
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void visor$canGetHurtByPlayer(DamageSource damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = damageSource.m_7639_();
        ServerPlayer damager = null;
        if (entity instanceof ServerPlayer) {
            damager = (ServerPlayer)entity;
        } else if (entity instanceof AbstractArrow && ((AbstractArrow)entity).m_19749_() instanceof ServerPlayer) {
            damager = (ServerPlayer)((AbstractArrow)entity).m_19749_();
        }
        if (damager == null) {
            return;
        }
        VRServerPlayer damagerPlayer = VisorAPI.server().getVrPlayer(damager);
        VRServerPlayer thisPlayer = this.visor$getVrPlayer();
        boolean damagerHasVR = damagerPlayer != null && damagerPlayer.isVr();
        boolean victimHasVR = thisPlayer != null && thisPlayer.isVr();
        boolean blockedDamage = false;
        String blockedDamageCase = "";
        if (!VRServerSettings.isPvpVRvsVR() && damagerHasVR && victimHasVR) {
            blockedDamage = true;
            blockedDamageCase = "Server: cancelled VR vs VR player damage";
        } else if (!VRServerSettings.isPvpVRvsVanilla() && (!damagerHasVR && victimHasVR || damagerHasVR && !victimHasVR)) {
            blockedDamage = true;
            blockedDamageCase = "Server: cancelled NonVR vs VR player damage";
        }
        if (!blockedDamage) {
            return;
        }
        if (VRServerSettings.isNotifyPvpBlocked()) {
            damager.m_213846_((Component)Component.m_237113_((String)blockedDamageCase));
        }
        cir.setReturnValue((Object)false);
    }

    public void m_36346_() {
        VRServerPlayer vrServerPlayer = this.visor$getVrPlayer();
        if (vrServerPlayer != null && vrServerPlayer.isVr()) {
            Vec3 handDir = vrServerPlayer.getControllerDir(ControllerHand.MAIN);
            Vec3 handPos = vrServerPlayer.getControllerPos(ControllerHand.MAIN);
            float handAngle = (float)Math.toDegrees(Mth.m_14136_((double)handDir.f_82479_, (double)(-handDir.f_82481_)));
            double offsetX = -Mth.m_14031_((float)(handAngle * ((float)Math.PI / 180)));
            double offsetZ = Mth.m_14089_((float)(handAngle * ((float)Math.PI / 180)));
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, handPos.f_82479_ + offsetX, handPos.f_82480_, handPos.f_82481_ + offsetZ, 0, offsetX, 0.0, offsetZ, 0.0);
            }
        } else {
            super.m_36346_();
        }
    }

    @Unique
    private VRServerPlayer visor$getVrPlayer() {
        return VisorAPI.server().getVrPlayer((ServerPlayer)this);
    }
}

