/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.common.world.entity;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class EndermanMixins {

    @Mixin(value={EnderMan.class})
    public static abstract class EndermanMixin
    extends Monster {
        protected EndermanMixin(EntityType<? extends Monster> entityType, Level level) {
            super(entityType, level);
        }

        @Inject(at={@At(value="HEAD")}, method={"isLookingAtMe(Lnet/minecraft/world/entity/player/Player;)Z"}, cancellable=true)
        public void visor$vrPlayerLookingAtMe(Player player, CallbackInfoReturnable<Boolean> cir) {
            if (VisorAPI.server().isVRPlayer((ServerPlayer)player)) {
                cir.setReturnValue((Object)EndermanMixin.visor$canAttackVrPlayer((EnderMan)this, (ServerPlayer)player));
            }
        }

        @Unique
        private static boolean visor$canAttackVrPlayer(EnderMan enderman, ServerPlayer player) {
            ItemStack itemstack = (ItemStack)player.m_150109_().f_35975_.get(3);
            if (!itemstack.m_150930_(Items.f_42047_)) {
                VRServerPlayer serverPlayer = VisorAPI.server().getVrPlayer(player);
                if (serverPlayer == null) {
                    return false;
                }
                Vec3 hmdPos = serverPlayer.getHmdPos((Player)player);
                Vec3 relativePos = new Vec3(enderman.m_20185_() - hmdPos.f_82479_, enderman.m_20188_() - hmdPos.f_82480_, enderman.m_20189_() - hmdPos.f_82481_);
                double relativeLength = relativePos.m_82553_();
                relativePos = relativePos.m_82541_();
                double dotProd = serverPlayer.getHmdDir().m_82526_(relativePos);
                return dotProd > 0.975 && relativeLength < 128.0 && EndermanMixin.visor$canEntityBeSeen((Entity)enderman, serverPlayer.getHmdPos((Player)player));
            }
            return false;
        }

        @Unique
        private static boolean visor$canEntityBeSeen(Entity entity, Vec3 playerEyePos) {
            Vec3 entityEyePos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
            return entity.m_9236_().m_45547_(new ClipContext(playerEyePos, entityEyePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS;
        }
    }

    @Mixin(targets={"net.minecraft.world.entity.monster.EnderMan$EndermanFreezeWhenLookedAt"})
    public static class EndermanFreezeWhenLookedAtMixin {
        @Shadow
        @Nullable
        private LivingEntity f_32548_;
        @Final
        @Shadow
        private EnderMan f_32547_;

        @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/control/LookControl;setLookAt(DDD)V"), method={"tick"})
        public void visor$lookAtHmd(LookControl instance, double d, double e, double f) {
            LivingEntity livingEntity = this.f_32548_;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                VRServerPlayer serverPlayer = VisorAPI.server().getVrPlayer(player);
                if (serverPlayer == null || !serverPlayer.isVr()) {
                    return;
                }
                this.f_32547_.m_21563_().m_24964_(serverPlayer.getHmdPos((Player)player));
            } else {
                instance.m_24946_(d, e, f);
            }
        }
    }
}

