/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.common.world.entity;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.common.ControllerHand;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Projectile.class})
public abstract class ProjectileMixin
extends Entity
implements TraceableEntity {
    @Unique
    private Vec3 visor$savedHandDir;

    public ProjectileMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyVariable(method={"shootFromRotation(Lnet/minecraft/world/entity/Entity;FFFFF)V"}, at=@At(value="HEAD"), ordinal=3, argsOnly=true)
    public float visor$pVelocity(float pVelocity, Entity entity) {
        boolean isArrow;
        if (!(entity instanceof ServerPlayer)) {
            return pVelocity;
        }
        ServerPlayer player = (ServerPlayer)entity;
        VRServerPlayer serverPlayer = VisorAPI.server().getVrPlayer(player);
        if (serverPlayer == null || !serverPlayer.isVr()) {
            return pVelocity;
        }
        this.visor$savedHandDir = serverPlayer.getActiveHandDir();
        Projectile instance = (Projectile)this;
        boolean bl = isArrow = instance instanceof AbstractArrow && !(instance instanceof ThrownTrident);
        if (!isArrow || serverPlayer.getBowTension() <= 0.0f) {
            return pVelocity;
        }
        boolean bowInMainHand = this.visor$isBow(player.m_21120_(InteractionHand.MAIN_HAND));
        this.visor$savedHandDir = bowInMainHand ? serverPlayer.getControllerPos(ControllerHand.MAIN).m_82546_(serverPlayer.getControllerPos(ControllerHand.OFFHAND)).m_82541_() : serverPlayer.getControllerPos(ControllerHand.OFFHAND).m_82546_(serverPlayer.getControllerPos(ControllerHand.MAIN)).m_82541_();
        return pVelocity;
    }

    @ModifyVariable(method={"shootFromRotation(Lnet/minecraft/world/entity/Entity;FFFFF)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public float visor$vrPitch(float pX, Entity pProjectile) {
        if (this.visor$savedHandDir != null) {
            return -((float)Math.toDegrees(Math.asin(this.visor$savedHandDir.f_82480_ / this.visor$savedHandDir.m_82553_())));
        }
        return pX;
    }

    @ModifyVariable(method={"shootFromRotation(Lnet/minecraft/world/entity/Entity;FFFFF)V"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    public float visor$vrYaw(float pY, Entity pProjectile) {
        if (this.visor$savedHandDir != null) {
            float toRet = (float)Math.toDegrees(Mth.m_14136_((double)(-this.visor$savedHandDir.f_82479_), (double)this.visor$savedHandDir.f_82481_));
            this.visor$savedHandDir = null;
            return toRet;
        }
        return pY;
    }

    @Unique
    private boolean visor$isBow(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BowItem;
    }
}

