/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.common.world.entity.projectiles;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import me.phoenixra.visor.core.common.CommonUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Entity {
    @Shadow
    private double f_36698_;

    protected AbstractArrowMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;)V"})
    public void visor$setupPos(EntityType entityType, LivingEntity livingEntity, Level level, CallbackInfo ci) {
        Vec3 handPos;
        Vec3 handDir;
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        VRServerPlayer serverPlayer = VisorAPI.server().getVrPlayer(player);
        if (serverPlayer == null || !serverPlayer.isVr()) {
            return;
        }
        if (serverPlayer.getBowTension() > 0.0f) {
            handDir = serverPlayer.getActiveHandPos().m_82546_(serverPlayer.getActiveHandPos()).m_82541_();
            handPos = serverPlayer.getActiveHandPos();
        } else {
            handPos = serverPlayer.getActiveHandPos();
            handDir = serverPlayer.getActiveHandDir();
        }
        this.m_6034_(handPos.f_82479_ + handDir.f_82479_, handPos.f_82480_ + handDir.f_82480_, handPos.f_82481_ + handDir.f_82481_);
    }

    @Inject(at={@At(value="HEAD")}, method={"onHitEntity"})
    public void visor$damageMultiplier(EntityHitResult entityHitResult, CallbackInfo ci) {
        Entity entity = ((Projectile)this).m_19749_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer owner = (ServerPlayer)entity;
        VRServerPlayer serverPlayer = VisorAPI.server().getVrPlayer(owner);
        if (serverPlayer == null || !serverPlayer.isVr()) {
            return;
        }
        Vec3 hitPosHead = this.visor$getHitPosIfHead(entityHitResult);
        if (hitPosHead == null) {
            this.f_36698_ *= 2.0;
            return;
        }
        ((ServerLevel)this.m_9236_()).m_8624_(owner, (ParticleOptions)ParticleTypes.f_123797_, true, hitPosHead.f_82479_, hitPosHead.f_82480_, hitPosHead.f_82481_, 5, -this.m_20184_().f_82479_, -this.m_20184_().f_82480_, -this.m_20184_().f_82481_, 0.1);
        owner.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12018_), SoundSource.PLAYERS, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0.7f, 0.5f, owner.m_9236_().f_46441_.m_188505_()));
        this.f_36698_ *= 3.0;
    }

    @Unique
    private Vec3 visor$getHitPosIfHead(EntityHitResult hit) {
        AABB headBox = CommonUtils.getEntityHeadHitBox(hit.m_82443_(), 0.3);
        if (headBox == null) {
            return null;
        }
        Vec3 originHitPos = hit.m_82443_().m_20191_().m_82371_(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_().m_82490_(2.0))).orElse(this.m_20182_().m_82549_(this.m_20184_()));
        return headBox.m_82371_(this.m_20182_(), originHitPos).orElse(headBox.m_82390_(this.m_20182_()) ? this.m_20182_() : null);
    }
}

