/*
 * Decompiled with CFR 0.152.
 */
package me.phoenixra.visor.mixin.common.world.entity.projectiles;

import me.phoenixra.visor.api.VisorAPI;
import me.phoenixra.visor.api.server.player.VRServerPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends Entity {
    @Unique
    private VRServerPlayer visor$savedPlayer = null;
    @Unique
    private Vec3 visor$savedHandDir = null;
    @Unique
    private Vec3 visor$savedHandPos = null;

    protected FishingHookMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyVariable(at=@At(value="STORE"), method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;II)V"}, ordinal=0)
    private float visor$vrRotationX(float xRot, Player player) {
        this.visor$savedPlayer = VisorAPI.server().getVrPlayer((ServerPlayer)player);
        if (this.visor$savedPlayer == null || !this.visor$savedPlayer.isVr()) {
            return xRot;
        }
        this.visor$savedHandDir = this.visor$savedPlayer.getActiveHandDir();
        this.visor$savedHandPos = this.visor$savedPlayer.getActiveHandPos();
        return (float)Math.toDegrees(Math.asin(this.visor$savedHandDir.f_82480_ / this.visor$savedHandDir.m_82553_())) * -1.0f;
    }

    @ModifyVariable(at=@At(value="STORE"), method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;II)V"}, ordinal=1)
    private float visor$vrRotationY(float yRot) {
        if (this.visor$savedPlayer == null || !this.visor$savedPlayer.isVr()) {
            return yRot;
        }
        return (float)Math.toDegrees(Mth.m_14136_((double)(-this.visor$savedHandDir.f_82479_), (double)this.visor$savedHandDir.f_82481_));
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;moveTo(DDDFF)V"), method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;II)V"})
    private void visor$vrMoveTo(FishingHook instance, double x, double y, double z, float yRot, float xRot) {
        if (this.visor$savedPlayer == null || !this.visor$savedPlayer.isVr()) {
            this.m_7678_(x, y, z, yRot, xRot);
            this.visor$savedPlayer = null;
            return;
        }
        instance.m_7678_(this.visor$savedHandPos.f_82479_ + this.visor$savedHandDir.f_82479_ * (double)0.6f, this.visor$savedHandPos.f_82480_ + this.visor$savedHandDir.f_82480_ * (double)0.6f, this.visor$savedHandPos.f_82481_ + this.visor$savedHandDir.f_82481_ * (double)0.6f, yRot, xRot);
        this.visor$savedHandDir = null;
        this.visor$savedHandPos = null;
        this.visor$savedPlayer = null;
    }
}

