/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrBodyJointLocationsHTC;
import org.lwjgl.openxr.XrBodyJointsLocateInfoHTC;
import org.lwjgl.openxr.XrBodySkeletonHTC;
import org.lwjgl.openxr.XrBodyTrackerCreateInfoHTC;
import org.lwjgl.openxr.XrBodyTrackerHTC;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class HTCBodyTracking {
    public static final int XR_HTC_body_tracking_SPEC_VERSION = 1;
    public static final String XR_HTC_BODY_TRACKING_EXTENSION_NAME = "XR_HTC_body_tracking";
    public static final int XR_OBJECT_TYPE_BODY_TRACKER_HTC = 1000320000;
    public static final int XR_TYPE_SYSTEM_BODY_TRACKING_PROPERTIES_HTC = 1000320000;
    public static final int XR_TYPE_BODY_TRACKER_CREATE_INFO_HTC = 1000320001;
    public static final int XR_TYPE_BODY_JOINTS_LOCATE_INFO_HTC = 1000320002;
    public static final int XR_TYPE_BODY_JOINT_LOCATIONS_HTC = 1000320003;
    public static final int XR_TYPE_BODY_SKELETON_HTC = 1000320004;
    public static final int XR_BODY_JOINT_PELVIS_HTC = 0;
    public static final int XR_BODY_JOINT_LEFT_HIP_HTC = 1;
    public static final int XR_BODY_JOINT_LEFT_KNEE_HTC = 2;
    public static final int XR_BODY_JOINT_LEFT_ANKLE_HTC = 3;
    public static final int XR_BODY_JOINT_LEFT_FEET_HTC = 4;
    public static final int XR_BODY_JOINT_RIGHT_HIP_HTC = 5;
    public static final int XR_BODY_JOINT_RIGHT_KNEE_HTC = 6;
    public static final int XR_BODY_JOINT_RIGHT_ANKLE_HTC = 7;
    public static final int XR_BODY_JOINT_RIGHT_FEET_HTC = 8;
    public static final int XR_BODY_JOINT_WAIST_HTC = 9;
    public static final int XR_BODY_JOINT_SPINE_LOWER_HTC = 10;
    public static final int XR_BODY_JOINT_SPINE_MIDDLE_HTC = 11;
    public static final int XR_BODY_JOINT_SPINE_HIGH_HTC = 12;
    public static final int XR_BODY_JOINT_CHEST_HTC = 13;
    public static final int XR_BODY_JOINT_NECK_HTC = 14;
    public static final int XR_BODY_JOINT_HEAD_HTC = 15;
    public static final int XR_BODY_JOINT_LEFT_CLAVICLE_HTC = 16;
    public static final int XR_BODY_JOINT_LEFT_SCAPULA_HTC = 17;
    public static final int XR_BODY_JOINT_LEFT_ARM_HTC = 18;
    public static final int XR_BODY_JOINT_LEFT_ELBOW_HTC = 19;
    public static final int XR_BODY_JOINT_LEFT_WRIST_HTC = 20;
    public static final int XR_BODY_JOINT_RIGHT_CLAVICLE_HTC = 21;
    public static final int XR_BODY_JOINT_RIGHT_SCAPULA_HTC = 22;
    public static final int XR_BODY_JOINT_RIGHT_ARM_HTC = 23;
    public static final int XR_BODY_JOINT_RIGHT_ELBOW_HTC = 24;
    public static final int XR_BODY_JOINT_RIGHT_WRIST_HTC = 25;
    public static final int XR_BODY_JOINT_SET_FULL_HTC = 0;
    public static final int XR_BODY_JOINT_CONFIDENCE_NONE_HTC = 0;
    public static final int XR_BODY_JOINT_CONFIDENCE_LOW_HTC = 1;
    public static final int XR_BODY_JOINT_CONFIDENCE_HIGH_HTC = 2;
    public static final int XR_BODY_JOINT_COUNT_HTC = 26;

    protected HTCBodyTracking() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateBodyTrackerHTC(XrSession session, long createInfo, long bodyTracker) {
        long __functionAddress = session.getCapabilities().xrCreateBodyTrackerHTC;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)bodyTracker, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateBodyTrackerHTC(XrSession session, @NativeType(value="XrBodyTrackerCreateInfoHTC const *") XrBodyTrackerCreateInfoHTC createInfo, @NativeType(value="XrBodyTrackerHTC *") PointerBuffer bodyTracker) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)bodyTracker, (int)1);
        }
        return HTCBodyTracking.nxrCreateBodyTrackerHTC(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)bodyTracker));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyBodyTrackerHTC(XrBodyTrackerHTC bodyTracker) {
        long __functionAddress = bodyTracker.getCapabilities().xrDestroyBodyTrackerHTC;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)bodyTracker.address(), (long)__functionAddress);
    }

    public static int nxrLocateBodyJointsHTC(XrBodyTrackerHTC bodyTracker, long locateInfo, long locations) {
        long __functionAddress = bodyTracker.getCapabilities().xrLocateBodyJointsHTC;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrBodyJointsLocateInfoHTC.validate(locateInfo);
        }
        return JNI.callPPPI((long)bodyTracker.address(), (long)locateInfo, (long)locations, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrLocateBodyJointsHTC(XrBodyTrackerHTC bodyTracker, @NativeType(value="XrBodyJointsLocateInfoHTC const *") XrBodyJointsLocateInfoHTC locateInfo, @NativeType(value="XrBodyJointLocationsHTC *") XrBodyJointLocationsHTC locations) {
        return HTCBodyTracking.nxrLocateBodyJointsHTC(bodyTracker, locateInfo.address(), locations.address());
    }

    public static int nxrGetBodySkeletonHTC(XrBodyTrackerHTC bodyTracker, XrSpace baseSpace, int skeletonGenerationId, long skeleton) {
        long __functionAddress = bodyTracker.getCapabilities().xrGetBodySkeletonHTC;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)bodyTracker.address(), (long)baseSpace.address(), (int)skeletonGenerationId, (long)skeleton, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetBodySkeletonHTC(XrBodyTrackerHTC bodyTracker, XrSpace baseSpace, @NativeType(value="uint32_t") int skeletonGenerationId, @NativeType(value="XrBodySkeletonHTC *") XrBodySkeletonHTC skeleton) {
        return HTCBodyTracking.nxrGetBodySkeletonHTC(bodyTracker, baseSpace, skeletonGenerationId, skeleton.address());
    }
}

