/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrPassthroughColorLutCreateInfoMETA;
import org.lwjgl.openxr.XrPassthroughColorLutMETA;
import org.lwjgl.openxr.XrPassthroughColorLutUpdateInfoMETA;
import org.lwjgl.openxr.XrPassthroughFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class METAPassthroughColorLut {
    public static final int XR_META_passthrough_color_lut_SPEC_VERSION = 1;
    public static final String XR_META_PASSTHROUGH_COLOR_LUT_EXTENSION_NAME = "XR_META_passthrough_color_lut";
    public static final int XR_TYPE_SYSTEM_PASSTHROUGH_COLOR_LUT_PROPERTIES_META = 1000266000;
    public static final int XR_TYPE_PASSTHROUGH_COLOR_LUT_CREATE_INFO_META = 1000266001;
    public static final int XR_TYPE_PASSTHROUGH_COLOR_LUT_UPDATE_INFO_META = 1000266002;
    public static final int XR_TYPE_PASSTHROUGH_COLOR_MAP_LUT_META = 1000266100;
    public static final int XR_TYPE_PASSTHROUGH_COLOR_MAP_INTERPOLATED_LUT_META = 1000266101;
    public static final int XR_OBJECT_TYPE_PASSTHROUGH_COLOR_LUT_META = 1000266000;
    public static final int XR_ERROR_PASSTHROUGH_COLOR_LUT_BUFFER_SIZE_MISMATCH_META = -1000266000;
    public static final int XR_PASSTHROUGH_COLOR_LUT_CHANNELS_RGB_META = 1;
    public static final int XR_PASSTHROUGH_COLOR_LUT_CHANNELS_RGBA_META = 2;

    protected METAPassthroughColorLut() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreatePassthroughColorLutMETA(XrPassthroughFB passthrough, long createInfo, long colorLut) {
        long __functionAddress = passthrough.getCapabilities().xrCreatePassthroughColorLutMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrPassthroughColorLutCreateInfoMETA.validate(createInfo);
        }
        return JNI.callPPPI((long)passthrough.address(), (long)createInfo, (long)colorLut, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreatePassthroughColorLutMETA(XrPassthroughFB passthrough, @NativeType(value="XrPassthroughColorLutCreateInfoMETA const *") XrPassthroughColorLutCreateInfoMETA createInfo, @NativeType(value="XrPassthroughColorLutMETA *") PointerBuffer colorLut) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)colorLut, (int)1);
        }
        return METAPassthroughColorLut.nxrCreatePassthroughColorLutMETA(passthrough, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)colorLut));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyPassthroughColorLutMETA(XrPassthroughColorLutMETA colorLut) {
        long __functionAddress = colorLut.getCapabilities().xrDestroyPassthroughColorLutMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)colorLut.address(), (long)__functionAddress);
    }

    public static int nxrUpdatePassthroughColorLutMETA(XrPassthroughColorLutMETA colorLut, long updateInfo) {
        long __functionAddress = colorLut.getCapabilities().xrUpdatePassthroughColorLutMETA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrPassthroughColorLutUpdateInfoMETA.validate(updateInfo);
        }
        return JNI.callPPI((long)colorLut.address(), (long)updateInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrUpdatePassthroughColorLutMETA(XrPassthroughColorLutMETA colorLut, @NativeType(value="XrPassthroughColorLutUpdateInfoMETA const *") XrPassthroughColorLutUpdateInfoMETA updateInfo) {
        return METAPassthroughColorLut.nxrUpdatePassthroughColorLutMETA(colorLut, updateInfo.address());
    }
}

