/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrExportedLocalizationMapML;
import org.lwjgl.openxr.XrLocalizationEnableEventsInfoML;
import org.lwjgl.openxr.XrLocalizationMapImportInfoML;
import org.lwjgl.openxr.XrLocalizationMapQueryInfoBaseHeaderML;
import org.lwjgl.openxr.XrMapLocalizationRequestInfoML;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class MLLocalizationMap {
    public static final int XR_ML_localization_map_SPEC_VERSION = 1;
    public static final String XR_ML_LOCALIZATION_MAP_EXTENSION_NAME = "XR_ML_localization_map";
    public static final int XR_OBJECT_TYPE_EXPORTED_LOCALIZATION_MAP_ML = 1000139000;
    public static final int XR_TYPE_LOCALIZATION_MAP_ML = 1000139000;
    public static final int XR_TYPE_EVENT_DATA_LOCALIZATION_CHANGED_ML = 1000139001;
    public static final int XR_TYPE_MAP_LOCALIZATION_REQUEST_INFO_ML = 1000139002;
    public static final int XR_TYPE_LOCALIZATION_MAP_IMPORT_INFO_ML = 1000139003;
    public static final int XR_TYPE_LOCALIZATION_ENABLE_EVENTS_INFO_ML = 1000139004;
    public static final int XR_ERROR_LOCALIZATION_MAP_INCOMPATIBLE_ML = -1000139000;
    public static final int XR_ERROR_LOCALIZATION_MAP_UNAVAILABLE_ML = -1000139001;
    public static final int XR_ERROR_LOCALIZATION_MAP_FAIL_ML = -1000139002;
    public static final int XR_ERROR_LOCALIZATION_MAP_IMPORT_EXPORT_PERMISSION_DENIED_ML = -1000139003;
    public static final int XR_ERROR_LOCALIZATION_MAP_PERMISSION_DENIED_ML = -1000139004;
    public static final int XR_ERROR_LOCALIZATION_MAP_ALREADY_EXISTS_ML = -1000139005;
    public static final int XR_ERROR_LOCALIZATION_MAP_CANNOT_EXPORT_CLOUD_MAP_ML = -1000139006;
    public static final int XR_REFERENCE_SPACE_TYPE_LOCALIZATION_MAP_ML = 1000139000;
    public static final int XR_MAX_LOCALIZATION_MAP_NAME_LENGTH_ML = 64;
    public static final int XR_LOCALIZATION_MAP_STATE_NOT_LOCALIZED_ML = 0;
    public static final int XR_LOCALIZATION_MAP_STATE_LOCALIZED_ML = 1;
    public static final int XR_LOCALIZATION_MAP_STATE_LOCALIZATION_PENDING_ML = 2;
    public static final int XR_LOCALIZATION_MAP_STATE_LOCALIZATION_SLEEPING_BEFORE_RETRY_ML = 3;
    public static final int XR_LOCALIZATION_MAP_TYPE_ON_DEVICE_ML = 0;
    public static final int XR_LOCALIZATION_MAP_TYPE_CLOUD_ML = 1;
    public static final int XR_LOCALIZATION_MAP_CONFIDENCE_POOR_ML = 0;
    public static final int XR_LOCALIZATION_MAP_CONFIDENCE_FAIR_ML = 1;
    public static final int XR_LOCALIZATION_MAP_CONFIDENCE_GOOD_ML = 2;
    public static final int XR_LOCALIZATION_MAP_CONFIDENCE_EXCELLENT_ML = 3;
    public static final int XR_LOCALIZATION_MAP_ERROR_UNKNOWN_BIT_ML = 1;
    public static final int XR_LOCALIZATION_MAP_ERROR_OUT_OF_MAPPED_AREA_BIT_ML = 2;
    public static final int XR_LOCALIZATION_MAP_ERROR_LOW_FEATURE_COUNT_BIT_ML = 4;
    public static final int XR_LOCALIZATION_MAP_ERROR_EXCESSIVE_MOTION_BIT_ML = 8;
    public static final int XR_LOCALIZATION_MAP_ERROR_LOW_LIGHT_BIT_ML = 16;
    public static final int XR_LOCALIZATION_MAP_ERROR_HEADPOSE_BIT_ML = 32;

    protected MLLocalizationMap() {
        throw new UnsupportedOperationException();
    }

    public static int nxrEnableLocalizationEventsML(XrSession session, long info) {
        long __functionAddress = session.getCapabilities().xrEnableLocalizationEventsML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)session.address(), (long)info, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrEnableLocalizationEventsML(XrSession session, @NativeType(value="XrLocalizationEnableEventsInfoML const *") XrLocalizationEnableEventsInfoML info) {
        return MLLocalizationMap.nxrEnableLocalizationEventsML(session, info.address());
    }

    public static int nxrQueryLocalizationMapsML(XrSession session, long queryInfo, int mapCapacityInput, long mapCountOutput, long maps) {
        long __functionAddress = session.getCapabilities().xrQueryLocalizationMapsML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPI((long)session.address(), (long)queryInfo, (int)mapCapacityInput, (long)mapCountOutput, (long)maps, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrQueryLocalizationMapsML(XrSession session, @NativeType(value="XrLocalizationMapQueryInfoBaseHeaderML const *") @Nullable XrLocalizationMapQueryInfoBaseHeaderML queryInfo, @NativeType(value="uint32_t *") IntBuffer mapCountOutput, @NativeType(value="XrLocalizationMapML *")  @Nullable XrLocalizationMapML.Buffer maps) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)mapCountOutput, (int)1);
        }
        return MLLocalizationMap.nxrQueryLocalizationMapsML(session, MemoryUtil.memAddressSafe((Pointer)queryInfo), Checks.remainingSafe((CustomBuffer)maps), MemoryUtil.memAddress((IntBuffer)mapCountOutput), MemoryUtil.memAddressSafe((Pointer)maps));
    }

    public static int nxrRequestMapLocalizationML(XrSession session, long requestInfo) {
        long __functionAddress = session.getCapabilities().xrRequestMapLocalizationML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)session.address(), (long)requestInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrRequestMapLocalizationML(XrSession session, @NativeType(value="XrMapLocalizationRequestInfoML const *") XrMapLocalizationRequestInfoML requestInfo) {
        return MLLocalizationMap.nxrRequestMapLocalizationML(session, requestInfo.address());
    }

    public static int nxrImportLocalizationMapML(XrSession session, long importInfo, long mapUuid) {
        long __functionAddress = session.getCapabilities().xrImportLocalizationMapML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrLocalizationMapImportInfoML.validate(importInfo);
        }
        return JNI.callPPPI((long)session.address(), (long)importInfo, (long)mapUuid, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrImportLocalizationMapML(XrSession session, @NativeType(value="XrLocalizationMapImportInfoML const *") XrLocalizationMapImportInfoML importInfo, @NativeType(value="XrUuidEXT *") @Nullable XrUuidEXT mapUuid) {
        return MLLocalizationMap.nxrImportLocalizationMapML(session, importInfo.address(), MemoryUtil.memAddressSafe((Pointer)mapUuid));
    }

    public static int nxrCreateExportedLocalizationMapML(XrSession session, long mapUuid, long map) {
        long __functionAddress = session.getCapabilities().xrCreateExportedLocalizationMapML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)mapUuid, (long)map, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateExportedLocalizationMapML(XrSession session, @NativeType(value="XrUuidEXT const *") XrUuidEXT mapUuid, @NativeType(value="XrExportedLocalizationMapML *") PointerBuffer map) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)map, (int)1);
        }
        return MLLocalizationMap.nxrCreateExportedLocalizationMapML(session, mapUuid.address(), MemoryUtil.memAddress((CustomBuffer)map));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyExportedLocalizationMapML(XrExportedLocalizationMapML map) {
        long __functionAddress = map.getCapabilities().xrDestroyExportedLocalizationMapML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)map.address(), (long)__functionAddress);
    }

    public static int nxrGetExportedLocalizationMapDataML(XrExportedLocalizationMapML map, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = map.getCapabilities().xrGetExportedLocalizationMapDataML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)map.address(), (int)bufferCapacityInput, (long)bufferCountOutput, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetExportedLocalizationMapDataML(XrExportedLocalizationMapML map, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @NativeType(value="char *") @Nullable ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, (int)1);
        }
        return MLLocalizationMap.nxrGetExportedLocalizationMapDataML(map, Checks.remainingSafe((Buffer)buffer), MemoryUtil.memAddress((IntBuffer)bufferCountOutput), MemoryUtil.memAddressSafe((ByteBuffer)buffer));
    }
}

