/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrWorldMeshBufferML;
import org.lwjgl.openxr.XrWorldMeshBufferRecommendedSizeInfoML;
import org.lwjgl.openxr.XrWorldMeshBufferSizeML;
import org.lwjgl.openxr.XrWorldMeshDetectorCreateInfoML;
import org.lwjgl.openxr.XrWorldMeshDetectorML;
import org.lwjgl.openxr.XrWorldMeshGetInfoML;
import org.lwjgl.openxr.XrWorldMeshRequestCompletionInfoML;
import org.lwjgl.openxr.XrWorldMeshRequestCompletionML;
import org.lwjgl.openxr.XrWorldMeshStateRequestCompletionML;
import org.lwjgl.openxr.XrWorldMeshStateRequestInfoML;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MLWorldMeshDetection {
    public static final int XR_ML_world_mesh_detection_SPEC_VERSION = 1;
    public static final String XR_ML_WORLD_MESH_DETECTION_EXTENSION_NAME = "XR_ML_world_mesh_detection";
    public static final int XR_OBJECT_TYPE_WORLD_MESH_DETECTOR_ML = 1000474000;
    public static final int XR_ERROR_WORLD_MESH_DETECTOR_PERMISSION_DENIED_ML = -1000474000;
    public static final int XR_ERROR_WORLD_MESH_DETECTOR_SPACE_NOT_LOCATABLE_ML = -1000474001;
    public static final int XR_TYPE_WORLD_MESH_DETECTOR_CREATE_INFO_ML = 1000474001;
    public static final int XR_TYPE_WORLD_MESH_STATE_REQUEST_INFO_ML = 1000474002;
    public static final int XR_TYPE_WORLD_MESH_BLOCK_STATE_ML = 1000474003;
    public static final int XR_TYPE_WORLD_MESH_STATE_REQUEST_COMPLETION_ML = 1000474004;
    public static final int XR_TYPE_WORLD_MESH_BUFFER_RECOMMENDED_SIZE_INFO_ML = 1000474005;
    public static final int XR_TYPE_WORLD_MESH_BUFFER_SIZE_ML = 1000474006;
    public static final int XR_TYPE_WORLD_MESH_BUFFER_ML = 1000474007;
    public static final int XR_TYPE_WORLD_MESH_BLOCK_REQUEST_ML = 1000474008;
    public static final int XR_TYPE_WORLD_MESH_GET_INFO_ML = 1000474009;
    public static final int XR_TYPE_WORLD_MESH_BLOCK_ML = 1000474010;
    public static final int XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_ML = 1000474011;
    public static final int XR_TYPE_WORLD_MESH_REQUEST_COMPLETION_INFO_ML = 1000474012;
    public static final int XR_WORLD_MESH_DETECTOR_POINT_CLOUD_BIT_ML = 1;
    public static final int XR_WORLD_MESH_DETECTOR_COMPUTE_NORMALS_BIT_ML = 2;
    public static final int XR_WORLD_MESH_DETECTOR_COMPUTE_CONFIDENCE_BIT_ML = 4;
    public static final int XR_WORLD_MESH_DETECTOR_PLANARIZE_BIT_ML = 8;
    public static final int XR_WORLD_MESH_DETECTOR_REMOVE_MESH_SKIRT_BIT_ML = 16;
    public static final int XR_WORLD_MESH_DETECTOR_INDEX_ORDER_CW_BIT_ML = 32;
    public static final int XR_WORLD_MESH_DETECTOR_LOD_MINIMUM_ML = 0;
    public static final int XR_WORLD_MESH_DETECTOR_LOD_MEDIUM_ML = 1;
    public static final int XR_WORLD_MESH_DETECTOR_LOD_MAXIMUM_ML = 2;
    public static final int XR_WORLD_MESH_BLOCK_STATUS_NEW_ML = 0;
    public static final int XR_WORLD_MESH_BLOCK_STATUS_UPDATED_ML = 1;
    public static final int XR_WORLD_MESH_BLOCK_STATUS_DELETED_ML = 2;
    public static final int XR_WORLD_MESH_BLOCK_STATUS_UNCHANGED_ML = 3;
    public static final int XR_WORLD_MESH_BLOCK_RESULT_SUCCESS_ML = 0;
    public static final int XR_WORLD_MESH_BLOCK_RESULT_FAILED_ML = 1;
    public static final int XR_WORLD_MESH_BLOCK_RESULT_PENDING_ML = 2;
    public static final int XR_WORLD_MESH_BLOCK_RESULT_PARTIAL_UPDATE_ML = 3;

    protected MLWorldMeshDetection() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateWorldMeshDetectorML(XrSession session, long createInfo, long detector) {
        long __functionAddress = session.getCapabilities().xrCreateWorldMeshDetectorML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)detector, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateWorldMeshDetectorML(XrSession session, @NativeType(value="XrWorldMeshDetectorCreateInfoML const *") XrWorldMeshDetectorCreateInfoML createInfo, @NativeType(value="XrWorldMeshDetectorML *") PointerBuffer detector) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)detector, (int)1);
        }
        return MLWorldMeshDetection.nxrCreateWorldMeshDetectorML(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)detector));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyWorldMeshDetectorML(XrWorldMeshDetectorML detector) {
        long __functionAddress = detector.getCapabilities().xrDestroyWorldMeshDetectorML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)detector.address(), (long)__functionAddress);
    }

    public static int nxrRequestWorldMeshStateAsyncML(XrWorldMeshDetectorML detector, long stateRequest, long future) {
        long __functionAddress = detector.getCapabilities().xrRequestWorldMeshStateAsyncML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrWorldMeshStateRequestInfoML.validate(stateRequest);
        }
        return JNI.callPPPI((long)detector.address(), (long)stateRequest, (long)future, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrRequestWorldMeshStateAsyncML(XrWorldMeshDetectorML detector, @NativeType(value="XrWorldMeshStateRequestInfoML const *") XrWorldMeshStateRequestInfoML stateRequest, @NativeType(value="XrFutureEXT *") LongBuffer future) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)future, (int)1);
        }
        return MLWorldMeshDetection.nxrRequestWorldMeshStateAsyncML(detector, stateRequest.address(), MemoryUtil.memAddress((LongBuffer)future));
    }

    public static int nxrRequestWorldMeshStateCompleteML(XrWorldMeshDetectorML detector, long future, long completion) {
        long __functionAddress = detector.getCapabilities().xrRequestWorldMeshStateCompleteML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)detector.address(), (long)future, (long)completion, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrRequestWorldMeshStateCompleteML(XrWorldMeshDetectorML detector, @NativeType(value="XrFutureEXT") long future, @NativeType(value="XrWorldMeshStateRequestCompletionML *") XrWorldMeshStateRequestCompletionML completion) {
        return MLWorldMeshDetection.nxrRequestWorldMeshStateCompleteML(detector, future, completion.address());
    }

    public static int nxrGetWorldMeshBufferRecommendSizeML(XrWorldMeshDetectorML detector, long sizeInfo, long size) {
        long __functionAddress = detector.getCapabilities().xrGetWorldMeshBufferRecommendSizeML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)detector.address(), (long)sizeInfo, (long)size, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetWorldMeshBufferRecommendSizeML(XrWorldMeshDetectorML detector, @NativeType(value="XrWorldMeshBufferRecommendedSizeInfoML const *") XrWorldMeshBufferRecommendedSizeInfoML sizeInfo, @NativeType(value="XrWorldMeshBufferSizeML *") XrWorldMeshBufferSizeML size) {
        return MLWorldMeshDetection.nxrGetWorldMeshBufferRecommendSizeML(detector, sizeInfo.address(), size.address());
    }

    public static int nxrAllocateWorldMeshBufferML(XrWorldMeshDetectorML detector, long size, long buffer) {
        long __functionAddress = detector.getCapabilities().xrAllocateWorldMeshBufferML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)detector.address(), (long)size, (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrAllocateWorldMeshBufferML(XrWorldMeshDetectorML detector, @NativeType(value="XrWorldMeshBufferSizeML const *") XrWorldMeshBufferSizeML size, @NativeType(value="XrWorldMeshBufferML *") XrWorldMeshBufferML buffer) {
        return MLWorldMeshDetection.nxrAllocateWorldMeshBufferML(detector, size.address(), buffer.address());
    }

    public static int nxrFreeWorldMeshBufferML(XrWorldMeshDetectorML detector, long buffer) {
        long __functionAddress = detector.getCapabilities().xrFreeWorldMeshBufferML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrWorldMeshBufferML.validate(buffer);
        }
        return JNI.callPPI((long)detector.address(), (long)buffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrFreeWorldMeshBufferML(XrWorldMeshDetectorML detector, @NativeType(value="XrWorldMeshBufferML const *") XrWorldMeshBufferML buffer) {
        return MLWorldMeshDetection.nxrFreeWorldMeshBufferML(detector, buffer.address());
    }

    public static int nxrRequestWorldMeshAsyncML(XrWorldMeshDetectorML detector, long getInfo, long buffer, long future) {
        long __functionAddress = detector.getCapabilities().xrRequestWorldMeshAsyncML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrWorldMeshGetInfoML.validate(getInfo);
        }
        return JNI.callPPPPI((long)detector.address(), (long)getInfo, (long)buffer, (long)future, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrRequestWorldMeshAsyncML(XrWorldMeshDetectorML detector, @NativeType(value="XrWorldMeshGetInfoML const *") XrWorldMeshGetInfoML getInfo, @NativeType(value="XrWorldMeshBufferML *") XrWorldMeshBufferML buffer, @NativeType(value="XrFutureEXT *") LongBuffer future) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)future, (int)1);
        }
        return MLWorldMeshDetection.nxrRequestWorldMeshAsyncML(detector, getInfo.address(), buffer.address(), MemoryUtil.memAddress((LongBuffer)future));
    }

    public static int nxrRequestWorldMeshCompleteML(XrWorldMeshDetectorML detector, long completionInfo, long future, long completion) {
        long __functionAddress = detector.getCapabilities().xrRequestWorldMeshCompleteML;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrWorldMeshRequestCompletionInfoML.validate(completionInfo);
        }
        return JNI.callPPJPI((long)detector.address(), (long)completionInfo, (long)future, (long)completion, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrRequestWorldMeshCompleteML(XrWorldMeshDetectorML detector, @NativeType(value="XrWorldMeshRequestCompletionInfoML const *") XrWorldMeshRequestCompletionInfoML completionInfo, @NativeType(value="XrFutureEXT") long future, @NativeType(value="XrWorldMeshRequestCompletionML *") XrWorldMeshRequestCompletionML completion) {
        return MLWorldMeshDetection.nxrRequestWorldMeshCompleteML(detector, completionInfo.address(), future, completion.address());
    }
}

