/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActiveActionSet
extends Struct<XrActiveActionSet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIONSET;
    public static final int SUBACTIONPATH;

    protected XrActiveActionSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActiveActionSet create(long address, @Nullable ByteBuffer container) {
        return new XrActiveActionSet(address, container);
    }

    public XrActiveActionSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActiveActionSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrActionSet")
    public long actionSet() {
        return XrActiveActionSet.nactionSet(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrActiveActionSet.nsubactionPath(this.address());
    }

    public XrActiveActionSet actionSet(XrActionSet value) {
        XrActiveActionSet.nactionSet(this.address(), value);
        return this;
    }

    public XrActiveActionSet subactionPath(@NativeType(value="XrPath") long value) {
        XrActiveActionSet.nsubactionPath(this.address(), value);
        return this;
    }

    public XrActiveActionSet set(XrActionSet actionSet, long subactionPath) {
        this.actionSet(actionSet);
        this.subactionPath(subactionPath);
        return this;
    }

    public XrActiveActionSet set(XrActiveActionSet src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActiveActionSet malloc() {
        return new XrActiveActionSet(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActiveActionSet calloc() {
        return new XrActiveActionSet(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActiveActionSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActiveActionSet(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActiveActionSet create(long address) {
        return new XrActiveActionSet(address, null);
    }

    public static @Nullable XrActiveActionSet createSafe(long address) {
        return address == 0L ? null : new XrActiveActionSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActiveActionSet.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActiveActionSet.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActiveActionSet malloc(MemoryStack stack) {
        return new XrActiveActionSet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActiveActionSet calloc(MemoryStack stack) {
        return new XrActiveActionSet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nactionSet(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET));
    }

    public static long nsubactionPath(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SUBACTIONPATH));
    }

    public static void nactionSet(long struct, XrActionSet value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTIONSET), (long)value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SUBACTIONPATH), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET)));
    }

    static {
        Struct.Layout layout = XrActiveActionSet.__struct((Struct.Member[])new Struct.Member[]{XrActiveActionSet.__member((int)POINTER_SIZE), XrActiveActionSet.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIONSET = layout.offsetof(0);
        SUBACTIONPATH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrActiveActionSet, Buffer>
    implements NativeResource {
        private static final XrActiveActionSet ELEMENT_FACTORY = XrActiveActionSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrActiveActionSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrActionSet")
        public long actionSet() {
            return XrActiveActionSet.nactionSet(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrActiveActionSet.nsubactionPath(this.address());
        }

        public Buffer actionSet(XrActionSet value) {
            XrActiveActionSet.nactionSet(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrActiveActionSet.nsubactionPath(this.address(), value);
            return this;
        }
    }
}

