/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActiveActionSetPriorityEXT
extends Struct<XrActiveActionSetPriorityEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIONSET;
    public static final int PRIORITYOVERRIDE;

    protected XrActiveActionSetPriorityEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActiveActionSetPriorityEXT create(long address, @Nullable ByteBuffer container) {
        return new XrActiveActionSetPriorityEXT(address, container);
    }

    public XrActiveActionSetPriorityEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActiveActionSetPriorityEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrActionSet")
    public long actionSet() {
        return XrActiveActionSetPriorityEXT.nactionSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int priorityOverride() {
        return XrActiveActionSetPriorityEXT.npriorityOverride(this.address());
    }

    public XrActiveActionSetPriorityEXT actionSet(XrActionSet value) {
        XrActiveActionSetPriorityEXT.nactionSet(this.address(), value);
        return this;
    }

    public XrActiveActionSetPriorityEXT priorityOverride(@NativeType(value="uint32_t") int value) {
        XrActiveActionSetPriorityEXT.npriorityOverride(this.address(), value);
        return this;
    }

    public XrActiveActionSetPriorityEXT set(XrActionSet actionSet, int priorityOverride) {
        this.actionSet(actionSet);
        this.priorityOverride(priorityOverride);
        return this;
    }

    public XrActiveActionSetPriorityEXT set(XrActiveActionSetPriorityEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActiveActionSetPriorityEXT malloc() {
        return new XrActiveActionSetPriorityEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActiveActionSetPriorityEXT calloc() {
        return new XrActiveActionSetPriorityEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActiveActionSetPriorityEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActiveActionSetPriorityEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActiveActionSetPriorityEXT create(long address) {
        return new XrActiveActionSetPriorityEXT(address, null);
    }

    public static @Nullable XrActiveActionSetPriorityEXT createSafe(long address) {
        return address == 0L ? null : new XrActiveActionSetPriorityEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActiveActionSetPriorityEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActiveActionSetPriorityEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActiveActionSetPriorityEXT malloc(MemoryStack stack) {
        return new XrActiveActionSetPriorityEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActiveActionSetPriorityEXT calloc(MemoryStack stack) {
        return new XrActiveActionSetPriorityEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nactionSet(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET));
    }

    public static int npriorityOverride(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRIORITYOVERRIDE));
    }

    public static void nactionSet(long struct, XrActionSet value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTIONSET), (long)value.address());
    }

    public static void npriorityOverride(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PRIORITYOVERRIDE), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET)));
    }

    static {
        Struct.Layout layout = XrActiveActionSetPriorityEXT.__struct((Struct.Member[])new Struct.Member[]{XrActiveActionSetPriorityEXT.__member((int)POINTER_SIZE), XrActiveActionSetPriorityEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIONSET = layout.offsetof(0);
        PRIORITYOVERRIDE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrActiveActionSetPriorityEXT, Buffer>
    implements NativeResource {
        private static final XrActiveActionSetPriorityEXT ELEMENT_FACTORY = XrActiveActionSetPriorityEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrActiveActionSetPriorityEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrActionSet")
        public long actionSet() {
            return XrActiveActionSetPriorityEXT.nactionSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int priorityOverride() {
            return XrActiveActionSetPriorityEXT.npriorityOverride(this.address());
        }

        public Buffer actionSet(XrActionSet value) {
            XrActiveActionSetPriorityEXT.nactionSet(this.address(), value);
            return this;
        }

        public Buffer priorityOverride(@NativeType(value="uint32_t") int value) {
            XrActiveActionSetPriorityEXT.npriorityOverride(this.address(), value);
            return this;
        }
    }
}

