/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyJointLocationHTC
extends Struct<XrBodyJointLocationHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATIONFLAGS;
    public static final int POSE;

    protected XrBodyJointLocationHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBodyJointLocationHTC create(long address, @Nullable ByteBuffer container) {
        return new XrBodyJointLocationHTC(address, container);
    }

    public XrBodyJointLocationHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodyJointLocationHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrBodyJointLocationHTC.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrBodyJointLocationHTC.npose(this.address());
    }

    public static XrBodyJointLocationHTC malloc() {
        return new XrBodyJointLocationHTC(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBodyJointLocationHTC calloc() {
        return new XrBodyJointLocationHTC(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBodyJointLocationHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBodyJointLocationHTC(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBodyJointLocationHTC create(long address) {
        return new XrBodyJointLocationHTC(address, null);
    }

    public static @Nullable XrBodyJointLocationHTC createSafe(long address) {
        return address == 0L ? null : new XrBodyJointLocationHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBodyJointLocationHTC.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyJointLocationHTC.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodyJointLocationHTC malloc(MemoryStack stack) {
        return new XrBodyJointLocationHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodyJointLocationHTC calloc(MemoryStack stack) {
        return new XrBodyJointLocationHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlocationFlags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LOCATIONFLAGS));
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    static {
        Struct.Layout layout = XrBodyJointLocationHTC.__struct((Struct.Member[])new Struct.Member[]{XrBodyJointLocationHTC.__member((int)8), XrBodyJointLocationHTC.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATIONFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBodyJointLocationHTC, Buffer>
    implements NativeResource {
        private static final XrBodyJointLocationHTC ELEMENT_FACTORY = XrBodyJointLocationHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrBodyJointLocationHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrBodyJointLocationHTC.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrBodyJointLocationHTC.npose(this.address());
        }
    }
}

