/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyJointsLocateInfoFB
extends Struct<XrBodyJointsLocateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;

    protected XrBodyJointsLocateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBodyJointsLocateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrBodyJointsLocateInfoFB(address, container);
    }

    public XrBodyJointsLocateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodyJointsLocateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodyJointsLocateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBodyJointsLocateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrBodyJointsLocateInfoFB.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrBodyJointsLocateInfoFB.ntime(this.address());
    }

    public XrBodyJointsLocateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrBodyJointsLocateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB type$Default() {
        return this.type(1000076002);
    }

    public XrBodyJointsLocateInfoFB next(@NativeType(value="void const *") long value) {
        XrBodyJointsLocateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB baseSpace(XrSpace value) {
        XrBodyJointsLocateInfoFB.nbaseSpace(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB time(@NativeType(value="XrTime") long value) {
        XrBodyJointsLocateInfoFB.ntime(this.address(), value);
        return this;
    }

    public XrBodyJointsLocateInfoFB set(int type, long next, XrSpace baseSpace, long time) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        return this;
    }

    public XrBodyJointsLocateInfoFB set(XrBodyJointsLocateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodyJointsLocateInfoFB malloc() {
        return new XrBodyJointsLocateInfoFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBodyJointsLocateInfoFB calloc() {
        return new XrBodyJointsLocateInfoFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBodyJointsLocateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBodyJointsLocateInfoFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBodyJointsLocateInfoFB create(long address) {
        return new XrBodyJointsLocateInfoFB(address, null);
    }

    public static @Nullable XrBodyJointsLocateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrBodyJointsLocateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBodyJointsLocateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyJointsLocateInfoFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodyJointsLocateInfoFB malloc(MemoryStack stack) {
        return new XrBodyJointsLocateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodyJointsLocateInfoFB calloc(MemoryStack stack) {
        return new XrBodyJointsLocateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE));
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIME));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASESPACE), (long)value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIME), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE)));
    }

    static {
        Struct.Layout layout = XrBodyJointsLocateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrBodyJointsLocateInfoFB.__member((int)4), XrBodyJointsLocateInfoFB.__member((int)POINTER_SIZE), XrBodyJointsLocateInfoFB.__member((int)POINTER_SIZE), XrBodyJointsLocateInfoFB.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrBodyJointsLocateInfoFB, Buffer>
    implements NativeResource {
        private static final XrBodyJointsLocateInfoFB ELEMENT_FACTORY = XrBodyJointsLocateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrBodyJointsLocateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodyJointsLocateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBodyJointsLocateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrBodyJointsLocateInfoFB.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrBodyJointsLocateInfoFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodyJointsLocateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBodyJointsLocateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrBodyJointsLocateInfoFB.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrBodyJointsLocateInfoFB.ntime(this.address(), value);
            return this;
        }
    }
}

