/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrBodySkeletonJointFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodySkeletonFB
extends Struct<XrBodySkeletonFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int JOINTCOUNT;
    public static final int JOINTS;

    protected XrBodySkeletonFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBodySkeletonFB create(long address, @Nullable ByteBuffer container) {
        return new XrBodySkeletonFB(address, container);
    }

    public XrBodySkeletonFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodySkeletonFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodySkeletonFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrBodySkeletonFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCount() {
        return XrBodySkeletonFB.njointCount(this.address());
    }

    @NativeType(value="XrBodySkeletonJointFB *")
    public XrBodySkeletonJointFB.Buffer joints() {
        return XrBodySkeletonFB.njoints(this.address());
    }

    public XrBodySkeletonFB type(@NativeType(value="XrStructureType") int value) {
        XrBodySkeletonFB.ntype(this.address(), value);
        return this;
    }

    public XrBodySkeletonFB type$Default() {
        return this.type(1000076006);
    }

    public XrBodySkeletonFB next(@NativeType(value="void *") long value) {
        XrBodySkeletonFB.nnext(this.address(), value);
        return this;
    }

    public XrBodySkeletonFB joints(@NativeType(value="XrBodySkeletonJointFB *") XrBodySkeletonJointFB.Buffer value) {
        XrBodySkeletonFB.njoints(this.address(), value);
        return this;
    }

    public XrBodySkeletonFB set(int type, long next, XrBodySkeletonJointFB.Buffer joints) {
        this.type(type);
        this.next(next);
        this.joints(joints);
        return this;
    }

    public XrBodySkeletonFB set(XrBodySkeletonFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodySkeletonFB malloc() {
        return new XrBodySkeletonFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBodySkeletonFB calloc() {
        return new XrBodySkeletonFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBodySkeletonFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBodySkeletonFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBodySkeletonFB create(long address) {
        return new XrBodySkeletonFB(address, null);
    }

    public static @Nullable XrBodySkeletonFB createSafe(long address) {
        return address == 0L ? null : new XrBodySkeletonFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBodySkeletonFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodySkeletonFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodySkeletonFB malloc(MemoryStack stack) {
        return new XrBodySkeletonFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodySkeletonFB calloc(MemoryStack stack) {
        return new XrBodySkeletonFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int njointCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)JOINTCOUNT));
    }

    public static XrBodySkeletonJointFB.Buffer njoints(long struct) {
        return XrBodySkeletonJointFB.create(MemoryUtil.memGetAddress((long)(struct + (long)JOINTS)), XrBodySkeletonFB.njointCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void njointCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)JOINTCOUNT), (int)value);
    }

    public static void njoints(long struct, XrBodySkeletonJointFB.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)JOINTS), (long)value.address());
        XrBodySkeletonFB.njointCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)JOINTS)));
    }

    static {
        Struct.Layout layout = XrBodySkeletonFB.__struct((Struct.Member[])new Struct.Member[]{XrBodySkeletonFB.__member((int)4), XrBodySkeletonFB.__member((int)POINTER_SIZE), XrBodySkeletonFB.__member((int)4), XrBodySkeletonFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        JOINTCOUNT = layout.offsetof(2);
        JOINTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrBodySkeletonFB, Buffer>
    implements NativeResource {
        private static final XrBodySkeletonFB ELEMENT_FACTORY = XrBodySkeletonFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrBodySkeletonFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodySkeletonFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrBodySkeletonFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCount() {
            return XrBodySkeletonFB.njointCount(this.address());
        }

        @NativeType(value="XrBodySkeletonJointFB *")
        public XrBodySkeletonJointFB.Buffer joints() {
            return XrBodySkeletonFB.njoints(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodySkeletonFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrBodySkeletonFB.nnext(this.address(), value);
            return this;
        }

        public Buffer joints(@NativeType(value="XrBodySkeletonJointFB *") XrBodySkeletonJointFB.Buffer value) {
            XrBodySkeletonFB.njoints(this.address(), value);
            return this;
        }
    }
}

