/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodySkeletonJointHTC
extends Struct<XrBodySkeletonJointHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSE;

    protected XrBodySkeletonJointHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBodySkeletonJointHTC create(long address, @Nullable ByteBuffer container) {
        return new XrBodySkeletonJointHTC(address, container);
    }

    public XrBodySkeletonJointHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodySkeletonJointHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef pose() {
        return XrBodySkeletonJointHTC.npose(this.address());
    }

    public XrBodySkeletonJointHTC pose(XrPosef value) {
        XrBodySkeletonJointHTC.npose(this.address(), value);
        return this;
    }

    public XrBodySkeletonJointHTC pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrBodySkeletonJointHTC set(XrBodySkeletonJointHTC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodySkeletonJointHTC malloc() {
        return new XrBodySkeletonJointHTC(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBodySkeletonJointHTC calloc() {
        return new XrBodySkeletonJointHTC(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBodySkeletonJointHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBodySkeletonJointHTC(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBodySkeletonJointHTC create(long address) {
        return new XrBodySkeletonJointHTC(address, null);
    }

    public static @Nullable XrBodySkeletonJointHTC createSafe(long address) {
        return address == 0L ? null : new XrBodySkeletonJointHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBodySkeletonJointHTC.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodySkeletonJointHTC.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodySkeletonJointHTC malloc(MemoryStack stack) {
        return new XrBodySkeletonJointHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodySkeletonJointHTC calloc(MemoryStack stack) {
        return new XrBodySkeletonJointHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrBodySkeletonJointHTC.__struct((Struct.Member[])new Struct.Member[]{XrBodySkeletonJointHTC.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrBodySkeletonJointHTC, Buffer>
    implements NativeResource {
        private static final XrBodySkeletonJointHTC ELEMENT_FACTORY = XrBodySkeletonJointHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrBodySkeletonJointHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef pose() {
            return XrBodySkeletonJointHTC.npose(this.address());
        }

        public Buffer pose(XrPosef value) {
            XrBodySkeletonJointHTC.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

