/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrustumf
extends Struct<XrFrustumf>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSE;
    public static final int FOV;
    public static final int NEARZ;
    public static final int FARZ;

    protected XrFrustumf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrFrustumf create(long address, @Nullable ByteBuffer container) {
        return new XrFrustumf(address, container);
    }

    public XrFrustumf(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFrustumf.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef pose() {
        return XrFrustumf.npose(this.address());
    }

    public XrFovf fov() {
        return XrFrustumf.nfov(this.address());
    }

    public float nearZ() {
        return XrFrustumf.nnearZ(this.address());
    }

    public float farZ() {
        return XrFrustumf.nfarZ(this.address());
    }

    public XrFrustumf pose(XrPosef value) {
        XrFrustumf.npose(this.address(), value);
        return this;
    }

    public XrFrustumf pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrFrustumf fov(XrFovf value) {
        XrFrustumf.nfov(this.address(), value);
        return this;
    }

    public XrFrustumf fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    public XrFrustumf nearZ(float value) {
        XrFrustumf.nnearZ(this.address(), value);
        return this;
    }

    public XrFrustumf farZ(float value) {
        XrFrustumf.nfarZ(this.address(), value);
        return this;
    }

    public XrFrustumf set(XrPosef pose, XrFovf fov, float nearZ, float farZ) {
        this.pose(pose);
        this.fov(fov);
        this.nearZ(nearZ);
        this.farZ(farZ);
        return this;
    }

    public XrFrustumf set(XrFrustumf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFrustumf malloc() {
        return new XrFrustumf(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrFrustumf calloc() {
        return new XrFrustumf(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrFrustumf create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrFrustumf(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrFrustumf create(long address) {
        return new XrFrustumf(address, null);
    }

    public static @Nullable XrFrustumf createSafe(long address) {
        return address == 0L ? null : new XrFrustumf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrFrustumf.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrustumf.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFrustumf malloc(MemoryStack stack) {
        return new XrFrustumf(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFrustumf calloc(MemoryStack stack) {
        return new XrFrustumf(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrFovf nfov(long struct) {
        return XrFovf.create(struct + (long)FOV);
    }

    public static float nnearZ(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)NEARZ));
    }

    public static float nfarZ(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FARZ));
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nfov(long struct, XrFovf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOV), (long)XrFovf.SIZEOF);
    }

    public static void nnearZ(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)NEARZ), (float)value);
    }

    public static void nfarZ(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)FARZ), (float)value);
    }

    static {
        Struct.Layout layout = XrFrustumf.__struct((Struct.Member[])new Struct.Member[]{XrFrustumf.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrFrustumf.__member((int)XrFovf.SIZEOF, (int)XrFovf.ALIGNOF), XrFrustumf.__member((int)4), XrFrustumf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSE = layout.offsetof(0);
        FOV = layout.offsetof(1);
        NEARZ = layout.offsetof(2);
        FARZ = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrFrustumf, Buffer>
    implements NativeResource {
        private static final XrFrustumf ELEMENT_FACTORY = XrFrustumf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrFrustumf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef pose() {
            return XrFrustumf.npose(this.address());
        }

        public XrFovf fov() {
            return XrFrustumf.nfov(this.address());
        }

        public float nearZ() {
            return XrFrustumf.nnearZ(this.address());
        }

        public float farZ() {
            return XrFrustumf.nfarZ(this.address());
        }

        public Buffer pose(XrPosef value) {
            XrFrustumf.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer fov(XrFovf value) {
            XrFrustumf.nfov(this.address(), value);
            return this;
        }

        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }

        public Buffer nearZ(float value) {
            XrFrustumf.nnearZ(this.address(), value);
            return this;
        }

        public Buffer farZ(float value) {
            XrFrustumf.nfarZ(this.address(), value);
            return this;
        }
    }
}

