/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsRequirementsVulkanKHR
extends Struct<XrGraphicsRequirementsVulkanKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MINAPIVERSIONSUPPORTED;
    public static final int MAXAPIVERSIONSUPPORTED;

    protected XrGraphicsRequirementsVulkanKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrGraphicsRequirementsVulkanKHR create(long address, @Nullable ByteBuffer container) {
        return new XrGraphicsRequirementsVulkanKHR(address, container);
    }

    public XrGraphicsRequirementsVulkanKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrGraphicsRequirementsVulkanKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsRequirementsVulkanKHR.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrGraphicsRequirementsVulkanKHR.nnext(this.address());
    }

    @NativeType(value="XrVersion")
    public long minApiVersionSupported() {
        return XrGraphicsRequirementsVulkanKHR.nminApiVersionSupported(this.address());
    }

    @NativeType(value="XrVersion")
    public long maxApiVersionSupported() {
        return XrGraphicsRequirementsVulkanKHR.nmaxApiVersionSupported(this.address());
    }

    public XrGraphicsRequirementsVulkanKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsRequirementsVulkanKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsVulkanKHR type$Default() {
        return this.type(1000025002);
    }

    public XrGraphicsRequirementsVulkanKHR next(@NativeType(value="void *") long value) {
        XrGraphicsRequirementsVulkanKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsVulkanKHR minApiVersionSupported(@NativeType(value="XrVersion") long value) {
        XrGraphicsRequirementsVulkanKHR.nminApiVersionSupported(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsVulkanKHR maxApiVersionSupported(@NativeType(value="XrVersion") long value) {
        XrGraphicsRequirementsVulkanKHR.nmaxApiVersionSupported(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsVulkanKHR set(int type, long next, long minApiVersionSupported, long maxApiVersionSupported) {
        this.type(type);
        this.next(next);
        this.minApiVersionSupported(minApiVersionSupported);
        this.maxApiVersionSupported(maxApiVersionSupported);
        return this;
    }

    public XrGraphicsRequirementsVulkanKHR set(XrGraphicsRequirementsVulkanKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGraphicsRequirementsVulkanKHR malloc() {
        return new XrGraphicsRequirementsVulkanKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrGraphicsRequirementsVulkanKHR calloc() {
        return new XrGraphicsRequirementsVulkanKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrGraphicsRequirementsVulkanKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrGraphicsRequirementsVulkanKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrGraphicsRequirementsVulkanKHR create(long address) {
        return new XrGraphicsRequirementsVulkanKHR(address, null);
    }

    public static @Nullable XrGraphicsRequirementsVulkanKHR createSafe(long address) {
        return address == 0L ? null : new XrGraphicsRequirementsVulkanKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrGraphicsRequirementsVulkanKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsRequirementsVulkanKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrGraphicsRequirementsVulkanKHR malloc(MemoryStack stack) {
        return new XrGraphicsRequirementsVulkanKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrGraphicsRequirementsVulkanKHR calloc(MemoryStack stack) {
        return new XrGraphicsRequirementsVulkanKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nminApiVersionSupported(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MINAPIVERSIONSUPPORTED));
    }

    public static long nmaxApiVersionSupported(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MAXAPIVERSIONSUPPORTED));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nminApiVersionSupported(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MINAPIVERSIONSUPPORTED), (long)value);
    }

    public static void nmaxApiVersionSupported(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MAXAPIVERSIONSUPPORTED), (long)value);
    }

    static {
        Struct.Layout layout = XrGraphicsRequirementsVulkanKHR.__struct((Struct.Member[])new Struct.Member[]{XrGraphicsRequirementsVulkanKHR.__member((int)4), XrGraphicsRequirementsVulkanKHR.__member((int)POINTER_SIZE), XrGraphicsRequirementsVulkanKHR.__member((int)8), XrGraphicsRequirementsVulkanKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MINAPIVERSIONSUPPORTED = layout.offsetof(2);
        MAXAPIVERSIONSUPPORTED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsRequirementsVulkanKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsRequirementsVulkanKHR ELEMENT_FACTORY = XrGraphicsRequirementsVulkanKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrGraphicsRequirementsVulkanKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsRequirementsVulkanKHR.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrGraphicsRequirementsVulkanKHR.nnext(this.address());
        }

        @NativeType(value="XrVersion")
        public long minApiVersionSupported() {
            return XrGraphicsRequirementsVulkanKHR.nminApiVersionSupported(this.address());
        }

        @NativeType(value="XrVersion")
        public long maxApiVersionSupported() {
            return XrGraphicsRequirementsVulkanKHR.nmaxApiVersionSupported(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsRequirementsVulkanKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000025002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrGraphicsRequirementsVulkanKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer minApiVersionSupported(@NativeType(value="XrVersion") long value) {
            XrGraphicsRequirementsVulkanKHR.nminApiVersionSupported(this.address(), value);
            return this;
        }

        public Buffer maxApiVersionSupported(@NativeType(value="XrVersion") long value) {
            XrGraphicsRequirementsVulkanKHR.nmaxApiVersionSupported(this.address(), value);
            return this;
        }
    }
}

