/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshSpaceCreateInfoMSFT
extends Struct<XrHandMeshSpaceCreateInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int HANDPOSETYPE;
    public static final int POSEINHANDMESHSPACE;

    protected XrHandMeshSpaceCreateInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandMeshSpaceCreateInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrHandMeshSpaceCreateInfoMSFT(address, container);
    }

    public XrHandMeshSpaceCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandMeshSpaceCreateInfoMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandMeshSpaceCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHandMeshSpaceCreateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrHandPoseTypeMSFT")
    public int handPoseType() {
        return XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address());
    }

    public XrPosef poseInHandMeshSpace() {
        return XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address());
    }

    public XrHandMeshSpaceCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrHandMeshSpaceCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT type$Default() {
        return this.type(1000052001);
    }

    public XrHandMeshSpaceCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrHandMeshSpaceCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT handPoseType(@NativeType(value="XrHandPoseTypeMSFT") int value) {
        XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT poseInHandMeshSpace(XrPosef value) {
        XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT poseInHandMeshSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInHandMeshSpace());
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT set(int type, long next, int handPoseType, XrPosef poseInHandMeshSpace) {
        this.type(type);
        this.next(next);
        this.handPoseType(handPoseType);
        this.poseInHandMeshSpace(poseInHandMeshSpace);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT set(XrHandMeshSpaceCreateInfoMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandMeshSpaceCreateInfoMSFT malloc() {
        return new XrHandMeshSpaceCreateInfoMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandMeshSpaceCreateInfoMSFT calloc() {
        return new XrHandMeshSpaceCreateInfoMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandMeshSpaceCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandMeshSpaceCreateInfoMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandMeshSpaceCreateInfoMSFT create(long address) {
        return new XrHandMeshSpaceCreateInfoMSFT(address, null);
    }

    public static @Nullable XrHandMeshSpaceCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrHandMeshSpaceCreateInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandMeshSpaceCreateInfoMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshSpaceCreateInfoMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandMeshSpaceCreateInfoMSFT malloc(MemoryStack stack) {
        return new XrHandMeshSpaceCreateInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandMeshSpaceCreateInfoMSFT calloc(MemoryStack stack) {
        return new XrHandMeshSpaceCreateInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nhandPoseType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HANDPOSETYPE));
    }

    public static XrPosef nposeInHandMeshSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINHANDMESHSPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nhandPoseType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HANDPOSETYPE), (int)value);
    }

    public static void nposeInHandMeshSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSEINHANDMESHSPACE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrHandMeshSpaceCreateInfoMSFT.__struct((Struct.Member[])new Struct.Member[]{XrHandMeshSpaceCreateInfoMSFT.__member((int)4), XrHandMeshSpaceCreateInfoMSFT.__member((int)POINTER_SIZE), XrHandMeshSpaceCreateInfoMSFT.__member((int)4), XrHandMeshSpaceCreateInfoMSFT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        HANDPOSETYPE = layout.offsetof(2);
        POSEINHANDMESHSPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshSpaceCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshSpaceCreateInfoMSFT ELEMENT_FACTORY = XrHandMeshSpaceCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrHandMeshSpaceCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandMeshSpaceCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHandMeshSpaceCreateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrHandPoseTypeMSFT")
        public int handPoseType() {
            return XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address());
        }

        public XrPosef poseInHandMeshSpace() {
            return XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandMeshSpaceCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000052001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHandMeshSpaceCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer handPoseType(@NativeType(value="XrHandPoseTypeMSFT") int value) {
            XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address(), value);
            return this;
        }

        public Buffer poseInHandMeshSpace(XrPosef value) {
            XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address(), value);
            return this;
        }

        public Buffer poseInHandMeshSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInHandMeshSpace());
            return this;
        }
    }
}

