/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingScaleFB
extends Struct<XrHandTrackingScaleFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SENSOROUTPUT;
    public static final int CURRENTOUTPUT;
    public static final int OVERRIDEHANDSCALE;
    public static final int OVERRIDEVALUEINPUT;

    protected XrHandTrackingScaleFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandTrackingScaleFB create(long address, @Nullable ByteBuffer container) {
        return new XrHandTrackingScaleFB(address, container);
    }

    public XrHandTrackingScaleFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandTrackingScaleFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingScaleFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingScaleFB.nnext(this.address());
    }

    public float sensorOutput() {
        return XrHandTrackingScaleFB.nsensorOutput(this.address());
    }

    public float currentOutput() {
        return XrHandTrackingScaleFB.ncurrentOutput(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean overrideHandScale() {
        return XrHandTrackingScaleFB.noverrideHandScale(this.address()) != 0;
    }

    public float overrideValueInput() {
        return XrHandTrackingScaleFB.noverrideValueInput(this.address());
    }

    public XrHandTrackingScaleFB type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingScaleFB.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingScaleFB type$Default() {
        return this.type(1000110003);
    }

    public XrHandTrackingScaleFB next(@NativeType(value="void *") long value) {
        XrHandTrackingScaleFB.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingScaleFB set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHandTrackingScaleFB set(XrHandTrackingScaleFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandTrackingScaleFB malloc() {
        return new XrHandTrackingScaleFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandTrackingScaleFB calloc() {
        return new XrHandTrackingScaleFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandTrackingScaleFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandTrackingScaleFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandTrackingScaleFB create(long address) {
        return new XrHandTrackingScaleFB(address, null);
    }

    public static @Nullable XrHandTrackingScaleFB createSafe(long address) {
        return address == 0L ? null : new XrHandTrackingScaleFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandTrackingScaleFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingScaleFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandTrackingScaleFB malloc(MemoryStack stack) {
        return new XrHandTrackingScaleFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandTrackingScaleFB calloc(MemoryStack stack) {
        return new XrHandTrackingScaleFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static float nsensorOutput(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SENSOROUTPUT));
    }

    public static float ncurrentOutput(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)CURRENTOUTPUT));
    }

    public static int noverrideHandScale(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OVERRIDEHANDSCALE));
    }

    public static float noverrideValueInput(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)OVERRIDEVALUEINPUT));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrHandTrackingScaleFB.__struct((Struct.Member[])new Struct.Member[]{XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)POINTER_SIZE), XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)4), XrHandTrackingScaleFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SENSOROUTPUT = layout.offsetof(2);
        CURRENTOUTPUT = layout.offsetof(3);
        OVERRIDEHANDSCALE = layout.offsetof(4);
        OVERRIDEVALUEINPUT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingScaleFB, Buffer>
    implements NativeResource {
        private static final XrHandTrackingScaleFB ELEMENT_FACTORY = XrHandTrackingScaleFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrHandTrackingScaleFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingScaleFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingScaleFB.nnext(this.address());
        }

        public float sensorOutput() {
            return XrHandTrackingScaleFB.nsensorOutput(this.address());
        }

        public float currentOutput() {
            return XrHandTrackingScaleFB.ncurrentOutput(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean overrideHandScale() {
            return XrHandTrackingScaleFB.noverrideHandScale(this.address()) != 0;
        }

        public float overrideValueInput() {
            return XrHandTrackingScaleFB.noverrideValueInput(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingScaleFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000110003);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingScaleFB.nnext(this.address(), value);
            return this;
        }
    }
}

