/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHapticAmplitudeEnvelopeVibrationFB;
import org.lwjgl.openxr.XrHapticPcmVibrationFB;
import org.lwjgl.openxr.XrHapticVibration;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHapticBaseHeader
extends Struct<XrHapticBaseHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    protected XrHapticBaseHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHapticBaseHeader create(long address, @Nullable ByteBuffer container) {
        return new XrHapticBaseHeader(address, container);
    }

    public XrHapticBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHapticBaseHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHapticBaseHeader.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHapticBaseHeader.nnext(this.address());
    }

    public XrHapticBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrHapticBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrHapticBaseHeader next(@NativeType(value="void const *") long value) {
        XrHapticBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrHapticBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHapticBaseHeader set(XrHapticBaseHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHapticBaseHeader malloc() {
        return new XrHapticBaseHeader(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHapticBaseHeader calloc() {
        return new XrHapticBaseHeader(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHapticBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHapticBaseHeader(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHapticBaseHeader create(long address) {
        return new XrHapticBaseHeader(address, null);
    }

    public static @Nullable XrHapticBaseHeader createSafe(long address) {
        return address == 0L ? null : new XrHapticBaseHeader(address, null);
    }

    public static XrHapticBaseHeader create(XrHapticVibration value) {
        return new XrHapticBaseHeader(value.address(), XrHapticBaseHeader.__getContainer((Struct)value));
    }

    public static XrHapticBaseHeader create(XrHapticAmplitudeEnvelopeVibrationFB value) {
        return new XrHapticBaseHeader(value.address(), XrHapticBaseHeader.__getContainer((Struct)value));
    }

    public static XrHapticBaseHeader create(XrHapticPcmVibrationFB value) {
        return new XrHapticBaseHeader(value.address(), XrHapticBaseHeader.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHapticBaseHeader.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHapticBaseHeader.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrHapticVibration.Buffer value) {
        return new Buffer(value.address(), XrHapticBaseHeader.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrHapticAmplitudeEnvelopeVibrationFB.Buffer value) {
        return new Buffer(value.address(), XrHapticBaseHeader.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static Buffer create(XrHapticPcmVibrationFB.Buffer value) {
        return new Buffer(value.address(), XrHapticBaseHeader.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrHapticBaseHeader malloc(MemoryStack stack) {
        return new XrHapticBaseHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHapticBaseHeader calloc(MemoryStack stack) {
        return new XrHapticBaseHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrHapticBaseHeader.__struct((Struct.Member[])new Struct.Member[]{XrHapticBaseHeader.__member((int)4), XrHapticBaseHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrHapticBaseHeader, Buffer>
    implements NativeResource {
        private static final XrHapticBaseHeader ELEMENT_FACTORY = XrHapticBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrHapticBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHapticBaseHeader.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHapticBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHapticBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHapticBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

