/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInstanceProperties
extends Struct<XrInstanceProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RUNTIMEVERSION;
    public static final int RUNTIMENAME;

    protected XrInstanceProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrInstanceProperties create(long address, @Nullable ByteBuffer container) {
        return new XrInstanceProperties(address, container);
    }

    public XrInstanceProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrInstanceProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInstanceProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrInstanceProperties.nnext(this.address());
    }

    @NativeType(value="XrVersion")
    public long runtimeVersion() {
        return XrInstanceProperties.nruntimeVersion(this.address());
    }

    @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
    public ByteBuffer runtimeName() {
        return XrInstanceProperties.nruntimeName(this.address());
    }

    @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
    public String runtimeNameString() {
        return XrInstanceProperties.nruntimeNameString(this.address());
    }

    public XrInstanceProperties type(@NativeType(value="XrStructureType") int value) {
        XrInstanceProperties.ntype(this.address(), value);
        return this;
    }

    public XrInstanceProperties type$Default() {
        return this.type(32);
    }

    public XrInstanceProperties next(@NativeType(value="void *") long value) {
        XrInstanceProperties.nnext(this.address(), value);
        return this;
    }

    public XrInstanceProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrInstanceProperties set(XrInstanceProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrInstanceProperties malloc() {
        return new XrInstanceProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrInstanceProperties calloc() {
        return new XrInstanceProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrInstanceProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrInstanceProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrInstanceProperties create(long address) {
        return new XrInstanceProperties(address, null);
    }

    public static @Nullable XrInstanceProperties createSafe(long address) {
        return address == 0L ? null : new XrInstanceProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrInstanceProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInstanceProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrInstanceProperties malloc(MemoryStack stack) {
        return new XrInstanceProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrInstanceProperties calloc(MemoryStack stack) {
        return new XrInstanceProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nruntimeVersion(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)RUNTIMEVERSION));
    }

    public static ByteBuffer nruntimeName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RUNTIMENAME), (int)128);
    }

    public static String nruntimeNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)RUNTIMENAME));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrInstanceProperties.__struct((Struct.Member[])new Struct.Member[]{XrInstanceProperties.__member((int)4), XrInstanceProperties.__member((int)POINTER_SIZE), XrInstanceProperties.__member((int)8), XrInstanceProperties.__array((int)1, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RUNTIMEVERSION = layout.offsetof(2);
        RUNTIMENAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrInstanceProperties, Buffer>
    implements NativeResource {
        private static final XrInstanceProperties ELEMENT_FACTORY = XrInstanceProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrInstanceProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInstanceProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrInstanceProperties.nnext(this.address());
        }

        @NativeType(value="XrVersion")
        public long runtimeVersion() {
            return XrInstanceProperties.nruntimeVersion(this.address());
        }

        @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
        public ByteBuffer runtimeName() {
            return XrInstanceProperties.nruntimeName(this.address());
        }

        @NativeType(value="char[XR_MAX_RUNTIME_NAME_SIZE]")
        public String runtimeNameString() {
            return XrInstanceProperties.nruntimeNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInstanceProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(32);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrInstanceProperties.nnext(this.address(), value);
            return this;
        }
    }
}

