/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorAprilTagInfoML
extends Struct<XrMarkerDetectorAprilTagInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int APRILTAGDICT;

    protected XrMarkerDetectorAprilTagInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrMarkerDetectorAprilTagInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorAprilTagInfoML(address, container);
    }

    public XrMarkerDetectorAprilTagInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrMarkerDetectorAprilTagInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorAprilTagInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerDetectorAprilTagInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerAprilTagDictML")
    public int aprilTagDict() {
        return XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address());
    }

    public XrMarkerDetectorAprilTagInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorAprilTagInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML type$Default() {
        return this.type(1000138004);
    }

    public XrMarkerDetectorAprilTagInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerDetectorAprilTagInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML aprilTagDict(@NativeType(value="XrMarkerAprilTagDictML") int value) {
        XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address(), value);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML set(int type, long next, int aprilTagDict) {
        this.type(type);
        this.next(next);
        this.aprilTagDict(aprilTagDict);
        return this;
    }

    public XrMarkerDetectorAprilTagInfoML set(XrMarkerDetectorAprilTagInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrMarkerDetectorAprilTagInfoML malloc() {
        return new XrMarkerDetectorAprilTagInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrMarkerDetectorAprilTagInfoML calloc() {
        return new XrMarkerDetectorAprilTagInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrMarkerDetectorAprilTagInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrMarkerDetectorAprilTagInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrMarkerDetectorAprilTagInfoML create(long address) {
        return new XrMarkerDetectorAprilTagInfoML(address, null);
    }

    public static @Nullable XrMarkerDetectorAprilTagInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorAprilTagInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrMarkerDetectorAprilTagInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorAprilTagInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorAprilTagInfoML malloc(MemoryStack stack) {
        return new XrMarkerDetectorAprilTagInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorAprilTagInfoML calloc(MemoryStack stack) {
        return new XrMarkerDetectorAprilTagInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int naprilTagDict(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)APRILTAGDICT));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void naprilTagDict(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)APRILTAGDICT), (int)value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorAprilTagInfoML.__struct((Struct.Member[])new Struct.Member[]{XrMarkerDetectorAprilTagInfoML.__member((int)4), XrMarkerDetectorAprilTagInfoML.__member((int)POINTER_SIZE), XrMarkerDetectorAprilTagInfoML.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        APRILTAGDICT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorAprilTagInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorAprilTagInfoML ELEMENT_FACTORY = XrMarkerDetectorAprilTagInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrMarkerDetectorAprilTagInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorAprilTagInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerDetectorAprilTagInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerAprilTagDictML")
        public int aprilTagDict() {
            return XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorAprilTagInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerDetectorAprilTagInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer aprilTagDict(@NativeType(value="XrMarkerAprilTagDictML") int value) {
            XrMarkerDetectorAprilTagInfoML.naprilTagDict(this.address(), value);
            return this;
        }
    }
}

