/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughCreateInfoFB
extends Struct<XrPassthroughCreateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;

    protected XrPassthroughCreateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrPassthroughCreateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrPassthroughCreateInfoFB(address, container);
    }

    public XrPassthroughCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPassthroughCreateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrPassthroughFlagsFB")
    public long flags() {
        return XrPassthroughCreateInfoFB.nflags(this.address());
    }

    public XrPassthroughCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoFB type$Default() {
        return this.type(1000118001);
    }

    public XrPassthroughCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrPassthroughCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoFB flags(@NativeType(value="XrPassthroughFlagsFB") long value) {
        XrPassthroughCreateInfoFB.nflags(this.address(), value);
        return this;
    }

    public XrPassthroughCreateInfoFB set(int type, long next, long flags) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        return this;
    }

    public XrPassthroughCreateInfoFB set(XrPassthroughCreateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPassthroughCreateInfoFB malloc() {
        return new XrPassthroughCreateInfoFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrPassthroughCreateInfoFB calloc() {
        return new XrPassthroughCreateInfoFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrPassthroughCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrPassthroughCreateInfoFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrPassthroughCreateInfoFB create(long address) {
        return new XrPassthroughCreateInfoFB(address, null);
    }

    public static @Nullable XrPassthroughCreateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrPassthroughCreateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrPassthroughCreateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughCreateInfoFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPassthroughCreateInfoFB malloc(MemoryStack stack) {
        return new XrPassthroughCreateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPassthroughCreateInfoFB calloc(MemoryStack stack) {
        return new XrPassthroughCreateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FLAGS));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FLAGS), (long)value);
    }

    static {
        Struct.Layout layout = XrPassthroughCreateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrPassthroughCreateInfoFB.__member((int)4), XrPassthroughCreateInfoFB.__member((int)POINTER_SIZE), XrPassthroughCreateInfoFB.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrPassthroughCreateInfoFB ELEMENT_FACTORY = XrPassthroughCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrPassthroughCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrPassthroughFlagsFB")
        public long flags() {
            return XrPassthroughCreateInfoFB.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrPassthroughFlagsFB") long value) {
            XrPassthroughCreateInfoFB.nflags(this.address(), value);
            return this;
        }
    }
}

