/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3DfEXT;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPlaneDetectorBeginInfoEXT
extends Struct<XrPlaneDetectorBeginInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int ORIENTATIONCOUNT;
    public static final int ORIENTATIONS;
    public static final int SEMANTICTYPECOUNT;
    public static final int SEMANTICTYPES;
    public static final int MAXPLANES;
    public static final int MINAREA;
    public static final int BOUNDINGBOXPOSE;
    public static final int BOUNDINGBOXEXTENT;

    protected XrPlaneDetectorBeginInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrPlaneDetectorBeginInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new XrPlaneDetectorBeginInfoEXT(address, container);
    }

    public XrPlaneDetectorBeginInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPlaneDetectorBeginInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPlaneDetectorBeginInfoEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPlaneDetectorBeginInfoEXT.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrPlaneDetectorBeginInfoEXT.ntime(this.address());
    }

    @NativeType(value="uint32_t")
    public int orientationCount() {
        return XrPlaneDetectorBeginInfoEXT.norientationCount(this.address());
    }

    @NativeType(value="XrPlaneDetectorOrientationEXT const *")
    public @Nullable IntBuffer orientations() {
        return XrPlaneDetectorBeginInfoEXT.norientations(this.address());
    }

    @NativeType(value="uint32_t")
    public int semanticTypeCount() {
        return XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address());
    }

    @NativeType(value="XrPlaneDetectorSemanticTypeEXT const *")
    public @Nullable IntBuffer semanticTypes() {
        return XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPlanes() {
        return XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address());
    }

    public float minArea() {
        return XrPlaneDetectorBeginInfoEXT.nminArea(this.address());
    }

    public XrPosef boundingBoxPose() {
        return XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address());
    }

    public XrExtent3DfEXT boundingBoxExtent() {
        return XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address());
    }

    public XrPlaneDetectorBeginInfoEXT type(@NativeType(value="XrStructureType") int value) {
        XrPlaneDetectorBeginInfoEXT.ntype(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT type$Default() {
        return this.type(1000429002);
    }

    public XrPlaneDetectorBeginInfoEXT next(@NativeType(value="void const *") long value) {
        XrPlaneDetectorBeginInfoEXT.nnext(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT baseSpace(XrSpace value) {
        XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT time(@NativeType(value="XrTime") long value) {
        XrPlaneDetectorBeginInfoEXT.ntime(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT orientationCount(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorBeginInfoEXT.norientationCount(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT orientations(@NativeType(value="XrPlaneDetectorOrientationEXT const *") @Nullable IntBuffer value) {
        XrPlaneDetectorBeginInfoEXT.norientations(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT semanticTypeCount(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT semanticTypes(@NativeType(value="XrPlaneDetectorSemanticTypeEXT const *") @Nullable IntBuffer value) {
        XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT maxPlanes(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT minArea(float value) {
        XrPlaneDetectorBeginInfoEXT.nminArea(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxPose(XrPosef value) {
        XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxPose(Consumer<XrPosef> consumer) {
        consumer.accept(this.boundingBoxPose());
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxExtent(XrExtent3DfEXT value) {
        XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address(), value);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT boundingBoxExtent(Consumer<XrExtent3DfEXT> consumer) {
        consumer.accept(this.boundingBoxExtent());
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT set(int type, long next, XrSpace baseSpace, long time, int orientationCount, @Nullable IntBuffer orientations, int semanticTypeCount, @Nullable IntBuffer semanticTypes, int maxPlanes, float minArea, XrPosef boundingBoxPose, XrExtent3DfEXT boundingBoxExtent) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.orientationCount(orientationCount);
        this.orientations(orientations);
        this.semanticTypeCount(semanticTypeCount);
        this.semanticTypes(semanticTypes);
        this.maxPlanes(maxPlanes);
        this.minArea(minArea);
        this.boundingBoxPose(boundingBoxPose);
        this.boundingBoxExtent(boundingBoxExtent);
        return this;
    }

    public XrPlaneDetectorBeginInfoEXT set(XrPlaneDetectorBeginInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPlaneDetectorBeginInfoEXT malloc() {
        return new XrPlaneDetectorBeginInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrPlaneDetectorBeginInfoEXT calloc() {
        return new XrPlaneDetectorBeginInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrPlaneDetectorBeginInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrPlaneDetectorBeginInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrPlaneDetectorBeginInfoEXT create(long address) {
        return new XrPlaneDetectorBeginInfoEXT(address, null);
    }

    public static @Nullable XrPlaneDetectorBeginInfoEXT createSafe(long address) {
        return address == 0L ? null : new XrPlaneDetectorBeginInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrPlaneDetectorBeginInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPlaneDetectorBeginInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPlaneDetectorBeginInfoEXT malloc(MemoryStack stack) {
        return new XrPlaneDetectorBeginInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPlaneDetectorBeginInfoEXT calloc(MemoryStack stack) {
        return new XrPlaneDetectorBeginInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE));
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIME));
    }

    public static int norientationCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ORIENTATIONCOUNT));
    }

    public static @Nullable IntBuffer norientations(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)ORIENTATIONS)), (int)XrPlaneDetectorBeginInfoEXT.norientationCount(struct));
    }

    public static int nsemanticTypeCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SEMANTICTYPECOUNT));
    }

    public static @Nullable IntBuffer nsemanticTypes(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)SEMANTICTYPES)), (int)XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(struct));
    }

    public static int nmaxPlanes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAXPLANES));
    }

    public static float nminArea(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MINAREA));
    }

    public static XrPosef nboundingBoxPose(long struct) {
        return XrPosef.create(struct + (long)BOUNDINGBOXPOSE);
    }

    public static XrExtent3DfEXT nboundingBoxExtent(long struct) {
        return XrExtent3DfEXT.create(struct + (long)BOUNDINGBOXEXTENT);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASESPACE), (long)value.address());
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIME), (long)value);
    }

    public static void norientationCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ORIENTATIONCOUNT), (int)value);
    }

    public static void norientations(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ORIENTATIONS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        if (value != null) {
            XrPlaneDetectorBeginInfoEXT.norientationCount(struct, value.remaining());
        }
    }

    public static void nsemanticTypeCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SEMANTICTYPECOUNT), (int)value);
    }

    public static void nsemanticTypes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SEMANTICTYPES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        if (value != null) {
            XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(struct, value.remaining());
        }
    }

    public static void nmaxPlanes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MAXPLANES), (int)value);
    }

    public static void nminArea(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MINAREA), (float)value);
    }

    public static void nboundingBoxPose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BOUNDINGBOXPOSE), (long)XrPosef.SIZEOF);
    }

    public static void nboundingBoxExtent(long struct, XrExtent3DfEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BOUNDINGBOXEXTENT), (long)XrExtent3DfEXT.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE)));
    }

    static {
        Struct.Layout layout = XrPlaneDetectorBeginInfoEXT.__struct((Struct.Member[])new Struct.Member[]{XrPlaneDetectorBeginInfoEXT.__member((int)4), XrPlaneDetectorBeginInfoEXT.__member((int)POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member((int)POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member((int)8), XrPlaneDetectorBeginInfoEXT.__member((int)4), XrPlaneDetectorBeginInfoEXT.__member((int)POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member((int)4), XrPlaneDetectorBeginInfoEXT.__member((int)POINTER_SIZE), XrPlaneDetectorBeginInfoEXT.__member((int)4), XrPlaneDetectorBeginInfoEXT.__member((int)4), XrPlaneDetectorBeginInfoEXT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrPlaneDetectorBeginInfoEXT.__member((int)XrExtent3DfEXT.SIZEOF, (int)XrExtent3DfEXT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        ORIENTATIONCOUNT = layout.offsetof(4);
        ORIENTATIONS = layout.offsetof(5);
        SEMANTICTYPECOUNT = layout.offsetof(6);
        SEMANTICTYPES = layout.offsetof(7);
        MAXPLANES = layout.offsetof(8);
        MINAREA = layout.offsetof(9);
        BOUNDINGBOXPOSE = layout.offsetof(10);
        BOUNDINGBOXEXTENT = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<XrPlaneDetectorBeginInfoEXT, Buffer>
    implements NativeResource {
        private static final XrPlaneDetectorBeginInfoEXT ELEMENT_FACTORY = XrPlaneDetectorBeginInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrPlaneDetectorBeginInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPlaneDetectorBeginInfoEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPlaneDetectorBeginInfoEXT.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrPlaneDetectorBeginInfoEXT.ntime(this.address());
        }

        @NativeType(value="uint32_t")
        public int orientationCount() {
            return XrPlaneDetectorBeginInfoEXT.norientationCount(this.address());
        }

        @NativeType(value="XrPlaneDetectorOrientationEXT const *")
        public @Nullable IntBuffer orientations() {
            return XrPlaneDetectorBeginInfoEXT.norientations(this.address());
        }

        @NativeType(value="uint32_t")
        public int semanticTypeCount() {
            return XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address());
        }

        @NativeType(value="XrPlaneDetectorSemanticTypeEXT const *")
        public @Nullable IntBuffer semanticTypes() {
            return XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPlanes() {
            return XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address());
        }

        public float minArea() {
            return XrPlaneDetectorBeginInfoEXT.nminArea(this.address());
        }

        public XrPosef boundingBoxPose() {
            return XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address());
        }

        public XrExtent3DfEXT boundingBoxExtent() {
            return XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPlaneDetectorBeginInfoEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000429002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPlaneDetectorBeginInfoEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrPlaneDetectorBeginInfoEXT.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrPlaneDetectorBeginInfoEXT.ntime(this.address(), value);
            return this;
        }

        public Buffer orientationCount(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorBeginInfoEXT.norientationCount(this.address(), value);
            return this;
        }

        public Buffer orientations(@NativeType(value="XrPlaneDetectorOrientationEXT const *") @Nullable IntBuffer value) {
            XrPlaneDetectorBeginInfoEXT.norientations(this.address(), value);
            return this;
        }

        public Buffer semanticTypeCount(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorBeginInfoEXT.nsemanticTypeCount(this.address(), value);
            return this;
        }

        public Buffer semanticTypes(@NativeType(value="XrPlaneDetectorSemanticTypeEXT const *") @Nullable IntBuffer value) {
            XrPlaneDetectorBeginInfoEXT.nsemanticTypes(this.address(), value);
            return this;
        }

        public Buffer maxPlanes(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorBeginInfoEXT.nmaxPlanes(this.address(), value);
            return this;
        }

        public Buffer minArea(float value) {
            XrPlaneDetectorBeginInfoEXT.nminArea(this.address(), value);
            return this;
        }

        public Buffer boundingBoxPose(XrPosef value) {
            XrPlaneDetectorBeginInfoEXT.nboundingBoxPose(this.address(), value);
            return this;
        }

        public Buffer boundingBoxPose(Consumer<XrPosef> consumer) {
            consumer.accept(this.boundingBoxPose());
            return this;
        }

        public Buffer boundingBoxExtent(XrExtent3DfEXT value) {
            XrPlaneDetectorBeginInfoEXT.nboundingBoxExtent(this.address(), value);
            return this;
        }

        public Buffer boundingBoxExtent(Consumer<XrExtent3DfEXT> consumer) {
            consumer.accept(this.boundingBoxExtent());
            return this;
        }
    }
}

