/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPlaneDetectorLocationEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPlaneDetectorLocationsEXT
extends Struct<XrPlaneDetectorLocationsEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PLANELOCATIONCAPACITYINPUT;
    public static final int PLANELOCATIONCOUNTOUTPUT;
    public static final int PLANELOCATIONS;

    protected XrPlaneDetectorLocationsEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrPlaneDetectorLocationsEXT create(long address, @Nullable ByteBuffer container) {
        return new XrPlaneDetectorLocationsEXT(address, container);
    }

    public XrPlaneDetectorLocationsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPlaneDetectorLocationsEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPlaneDetectorLocationsEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrPlaneDetectorLocationsEXT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int planeLocationCapacityInput() {
        return XrPlaneDetectorLocationsEXT.nplaneLocationCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int planeLocationCountOutput() {
        return XrPlaneDetectorLocationsEXT.nplaneLocationCountOutput(this.address());
    }

    @NativeType(value="XrPlaneDetectorLocationEXT *")
    public @Nullable XrPlaneDetectorLocationEXT.Buffer planeLocations() {
        return XrPlaneDetectorLocationsEXT.nplaneLocations(this.address());
    }

    public XrPlaneDetectorLocationsEXT type(@NativeType(value="XrStructureType") int value) {
        XrPlaneDetectorLocationsEXT.ntype(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationsEXT type$Default() {
        return this.type(1000429004);
    }

    public XrPlaneDetectorLocationsEXT next(@NativeType(value="void *") long value) {
        XrPlaneDetectorLocationsEXT.nnext(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationsEXT planeLocationCapacityInput(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorLocationsEXT.nplaneLocationCapacityInput(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationsEXT planeLocationCountOutput(@NativeType(value="uint32_t") int value) {
        XrPlaneDetectorLocationsEXT.nplaneLocationCountOutput(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationsEXT planeLocations(@NativeType(value="XrPlaneDetectorLocationEXT *") @Nullable XrPlaneDetectorLocationEXT.Buffer value) {
        XrPlaneDetectorLocationsEXT.nplaneLocations(this.address(), value);
        return this;
    }

    public XrPlaneDetectorLocationsEXT set(int type, long next, int planeLocationCapacityInput, int planeLocationCountOutput, @Nullable XrPlaneDetectorLocationEXT.Buffer planeLocations) {
        this.type(type);
        this.next(next);
        this.planeLocationCapacityInput(planeLocationCapacityInput);
        this.planeLocationCountOutput(planeLocationCountOutput);
        this.planeLocations(planeLocations);
        return this;
    }

    public XrPlaneDetectorLocationsEXT set(XrPlaneDetectorLocationsEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPlaneDetectorLocationsEXT malloc() {
        return new XrPlaneDetectorLocationsEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrPlaneDetectorLocationsEXT calloc() {
        return new XrPlaneDetectorLocationsEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrPlaneDetectorLocationsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrPlaneDetectorLocationsEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrPlaneDetectorLocationsEXT create(long address) {
        return new XrPlaneDetectorLocationsEXT(address, null);
    }

    public static @Nullable XrPlaneDetectorLocationsEXT createSafe(long address) {
        return address == 0L ? null : new XrPlaneDetectorLocationsEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrPlaneDetectorLocationsEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPlaneDetectorLocationsEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPlaneDetectorLocationsEXT malloc(MemoryStack stack) {
        return new XrPlaneDetectorLocationsEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPlaneDetectorLocationsEXT calloc(MemoryStack stack) {
        return new XrPlaneDetectorLocationsEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nplaneLocationCapacityInput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PLANELOCATIONCAPACITYINPUT));
    }

    public static int nplaneLocationCountOutput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PLANELOCATIONCOUNTOUTPUT));
    }

    public static @Nullable XrPlaneDetectorLocationEXT.Buffer nplaneLocations(long struct) {
        return XrPlaneDetectorLocationEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PLANELOCATIONS)), XrPlaneDetectorLocationsEXT.nplaneLocationCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nplaneLocationCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PLANELOCATIONCAPACITYINPUT), (int)value);
    }

    public static void nplaneLocationCountOutput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PLANELOCATIONCOUNTOUTPUT), (int)value);
    }

    public static void nplaneLocations(long struct, @Nullable XrPlaneDetectorLocationEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLANELOCATIONS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrPlaneDetectorLocationsEXT.nplaneLocationCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrPlaneDetectorLocationsEXT.__struct((Struct.Member[])new Struct.Member[]{XrPlaneDetectorLocationsEXT.__member((int)4), XrPlaneDetectorLocationsEXT.__member((int)POINTER_SIZE), XrPlaneDetectorLocationsEXT.__member((int)4), XrPlaneDetectorLocationsEXT.__member((int)4), XrPlaneDetectorLocationsEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PLANELOCATIONCAPACITYINPUT = layout.offsetof(2);
        PLANELOCATIONCOUNTOUTPUT = layout.offsetof(3);
        PLANELOCATIONS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrPlaneDetectorLocationsEXT, Buffer>
    implements NativeResource {
        private static final XrPlaneDetectorLocationsEXT ELEMENT_FACTORY = XrPlaneDetectorLocationsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrPlaneDetectorLocationsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPlaneDetectorLocationsEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrPlaneDetectorLocationsEXT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int planeLocationCapacityInput() {
            return XrPlaneDetectorLocationsEXT.nplaneLocationCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int planeLocationCountOutput() {
            return XrPlaneDetectorLocationsEXT.nplaneLocationCountOutput(this.address());
        }

        @NativeType(value="XrPlaneDetectorLocationEXT *")
        public @Nullable XrPlaneDetectorLocationEXT.Buffer planeLocations() {
            return XrPlaneDetectorLocationsEXT.nplaneLocations(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPlaneDetectorLocationsEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000429004);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrPlaneDetectorLocationsEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer planeLocationCapacityInput(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorLocationsEXT.nplaneLocationCapacityInput(this.address(), value);
            return this;
        }

        public Buffer planeLocationCountOutput(@NativeType(value="uint32_t") int value) {
            XrPlaneDetectorLocationsEXT.nplaneLocationCountOutput(this.address(), value);
            return this;
        }

        public Buffer planeLocations(@NativeType(value="XrPlaneDetectorLocationEXT *") @Nullable XrPlaneDetectorLocationEXT.Buffer value) {
            XrPlaneDetectorLocationsEXT.nplaneLocations(this.address(), value);
            return this;
        }
    }
}

