/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Di;
import org.lwjgl.openxr.XrOffset2Di;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRect2Di
extends Struct<XrRect2Di>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    protected XrRect2Di(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrRect2Di create(long address, @Nullable ByteBuffer container) {
        return new XrRect2Di(address, container);
    }

    public XrRect2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRect2Di.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrOffset2Di offset() {
        return XrRect2Di.noffset(this.address());
    }

    public XrExtent2Di extent() {
        return XrRect2Di.nextent(this.address());
    }

    public XrRect2Di offset(XrOffset2Di value) {
        XrRect2Di.noffset(this.address(), value);
        return this;
    }

    public XrRect2Di offset(Consumer<XrOffset2Di> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public XrRect2Di extent(XrExtent2Di value) {
        XrRect2Di.nextent(this.address(), value);
        return this;
    }

    public XrRect2Di extent(Consumer<XrExtent2Di> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public XrRect2Di set(XrOffset2Di offset, XrExtent2Di extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public XrRect2Di set(XrRect2Di src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRect2Di malloc() {
        return new XrRect2Di(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrRect2Di calloc() {
        return new XrRect2Di(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrRect2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrRect2Di(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrRect2Di create(long address) {
        return new XrRect2Di(address, null);
    }

    public static @Nullable XrRect2Di createSafe(long address) {
        return address == 0L ? null : new XrRect2Di(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrRect2Di.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRect2Di.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrRect2Di malloc(MemoryStack stack) {
        return new XrRect2Di(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrRect2Di calloc(MemoryStack stack) {
        return new XrRect2Di(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrOffset2Di noffset(long struct) {
        return XrOffset2Di.create(struct + (long)OFFSET);
    }

    public static XrExtent2Di nextent(long struct) {
        return XrExtent2Di.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, XrOffset2Di value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)XrOffset2Di.SIZEOF);
    }

    public static void nextent(long struct, XrExtent2Di value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)XrExtent2Di.SIZEOF);
    }

    static {
        Struct.Layout layout = XrRect2Di.__struct((Struct.Member[])new Struct.Member[]{XrRect2Di.__member((int)XrOffset2Di.SIZEOF, (int)XrOffset2Di.ALIGNOF), XrRect2Di.__member((int)XrExtent2Di.SIZEOF, (int)XrExtent2Di.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrRect2Di, Buffer>
    implements NativeResource {
        private static final XrRect2Di ELEMENT_FACTORY = XrRect2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrRect2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrOffset2Di offset() {
            return XrRect2Di.noffset(this.address());
        }

        public XrExtent2Di extent() {
            return XrRect2Di.nextent(this.address());
        }

        public Buffer offset(XrOffset2Di value) {
            XrRect2Di.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<XrOffset2Di> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(XrExtent2Di value) {
            XrRect2Di.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<XrExtent2Di> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

