/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRoomLayoutFB
extends Struct<XrRoomLayoutFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLOORUUID;
    public static final int CEILINGUUID;
    public static final int WALLUUIDCAPACITYINPUT;
    public static final int WALLUUIDCOUNTOUTPUT;
    public static final int WALLUUIDS;

    protected XrRoomLayoutFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrRoomLayoutFB create(long address, @Nullable ByteBuffer container) {
        return new XrRoomLayoutFB(address, container);
    }

    public XrRoomLayoutFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRoomLayoutFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRoomLayoutFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrRoomLayoutFB.nnext(this.address());
    }

    public XrUuidEXT floorUuid() {
        return XrRoomLayoutFB.nfloorUuid(this.address());
    }

    public XrUuidEXT ceilingUuid() {
        return XrRoomLayoutFB.nceilingUuid(this.address());
    }

    @NativeType(value="uint32_t")
    public int wallUuidCapacityInput() {
        return XrRoomLayoutFB.nwallUuidCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int wallUuidCountOutput() {
        return XrRoomLayoutFB.nwallUuidCountOutput(this.address());
    }

    @NativeType(value="XrUuidEXT *")
    public @Nullable XrUuidEXT.Buffer wallUuids() {
        return XrRoomLayoutFB.nwallUuids(this.address());
    }

    public XrRoomLayoutFB type(@NativeType(value="XrStructureType") int value) {
        XrRoomLayoutFB.ntype(this.address(), value);
        return this;
    }

    public XrRoomLayoutFB type$Default() {
        return this.type(1000175001);
    }

    public XrRoomLayoutFB next(@NativeType(value="void const *") long value) {
        XrRoomLayoutFB.nnext(this.address(), value);
        return this;
    }

    public XrRoomLayoutFB floorUuid(XrUuidEXT value) {
        XrRoomLayoutFB.nfloorUuid(this.address(), value);
        return this;
    }

    public XrRoomLayoutFB floorUuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.floorUuid());
        return this;
    }

    public XrRoomLayoutFB ceilingUuid(XrUuidEXT value) {
        XrRoomLayoutFB.nceilingUuid(this.address(), value);
        return this;
    }

    public XrRoomLayoutFB ceilingUuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.ceilingUuid());
        return this;
    }

    public XrRoomLayoutFB wallUuidCapacityInput(@NativeType(value="uint32_t") int value) {
        XrRoomLayoutFB.nwallUuidCapacityInput(this.address(), value);
        return this;
    }

    public XrRoomLayoutFB wallUuidCountOutput(@NativeType(value="uint32_t") int value) {
        XrRoomLayoutFB.nwallUuidCountOutput(this.address(), value);
        return this;
    }

    public XrRoomLayoutFB wallUuids(@NativeType(value="XrUuidEXT *") @Nullable XrUuidEXT.Buffer value) {
        XrRoomLayoutFB.nwallUuids(this.address(), value);
        return this;
    }

    public XrRoomLayoutFB set(int type, long next, XrUuidEXT floorUuid, XrUuidEXT ceilingUuid, int wallUuidCapacityInput, int wallUuidCountOutput, @Nullable XrUuidEXT.Buffer wallUuids) {
        this.type(type);
        this.next(next);
        this.floorUuid(floorUuid);
        this.ceilingUuid(ceilingUuid);
        this.wallUuidCapacityInput(wallUuidCapacityInput);
        this.wallUuidCountOutput(wallUuidCountOutput);
        this.wallUuids(wallUuids);
        return this;
    }

    public XrRoomLayoutFB set(XrRoomLayoutFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRoomLayoutFB malloc() {
        return new XrRoomLayoutFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrRoomLayoutFB calloc() {
        return new XrRoomLayoutFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrRoomLayoutFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrRoomLayoutFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrRoomLayoutFB create(long address) {
        return new XrRoomLayoutFB(address, null);
    }

    public static @Nullable XrRoomLayoutFB createSafe(long address) {
        return address == 0L ? null : new XrRoomLayoutFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrRoomLayoutFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRoomLayoutFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrRoomLayoutFB malloc(MemoryStack stack) {
        return new XrRoomLayoutFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrRoomLayoutFB calloc(MemoryStack stack) {
        return new XrRoomLayoutFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrUuidEXT nfloorUuid(long struct) {
        return XrUuidEXT.create(struct + (long)FLOORUUID);
    }

    public static XrUuidEXT nceilingUuid(long struct) {
        return XrUuidEXT.create(struct + (long)CEILINGUUID);
    }

    public static int nwallUuidCapacityInput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WALLUUIDCAPACITYINPUT));
    }

    public static int nwallUuidCountOutput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WALLUUIDCOUNTOUTPUT));
    }

    public static @Nullable XrUuidEXT.Buffer nwallUuids(long struct) {
        return XrUuidEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)WALLUUIDS)), XrRoomLayoutFB.nwallUuidCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nfloorUuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLOORUUID), (long)XrUuidEXT.SIZEOF);
    }

    public static void nceilingUuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CEILINGUUID), (long)XrUuidEXT.SIZEOF);
    }

    public static void nwallUuidCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WALLUUIDCAPACITYINPUT), (int)value);
    }

    public static void nwallUuidCountOutput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WALLUUIDCOUNTOUTPUT), (int)value);
    }

    public static void nwallUuids(long struct, @Nullable XrUuidEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WALLUUIDS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrRoomLayoutFB.nwallUuidCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrRoomLayoutFB.__struct((Struct.Member[])new Struct.Member[]{XrRoomLayoutFB.__member((int)4), XrRoomLayoutFB.__member((int)POINTER_SIZE), XrRoomLayoutFB.__member((int)XrUuidEXT.SIZEOF, (int)XrUuidEXT.ALIGNOF), XrRoomLayoutFB.__member((int)XrUuidEXT.SIZEOF, (int)XrUuidEXT.ALIGNOF), XrRoomLayoutFB.__member((int)4), XrRoomLayoutFB.__member((int)4), XrRoomLayoutFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLOORUUID = layout.offsetof(2);
        CEILINGUUID = layout.offsetof(3);
        WALLUUIDCAPACITYINPUT = layout.offsetof(4);
        WALLUUIDCOUNTOUTPUT = layout.offsetof(5);
        WALLUUIDS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrRoomLayoutFB, Buffer>
    implements NativeResource {
        private static final XrRoomLayoutFB ELEMENT_FACTORY = XrRoomLayoutFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrRoomLayoutFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRoomLayoutFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrRoomLayoutFB.nnext(this.address());
        }

        public XrUuidEXT floorUuid() {
            return XrRoomLayoutFB.nfloorUuid(this.address());
        }

        public XrUuidEXT ceilingUuid() {
            return XrRoomLayoutFB.nceilingUuid(this.address());
        }

        @NativeType(value="uint32_t")
        public int wallUuidCapacityInput() {
            return XrRoomLayoutFB.nwallUuidCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int wallUuidCountOutput() {
            return XrRoomLayoutFB.nwallUuidCountOutput(this.address());
        }

        @NativeType(value="XrUuidEXT *")
        public @Nullable XrUuidEXT.Buffer wallUuids() {
            return XrRoomLayoutFB.nwallUuids(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRoomLayoutFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000175001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrRoomLayoutFB.nnext(this.address(), value);
            return this;
        }

        public Buffer floorUuid(XrUuidEXT value) {
            XrRoomLayoutFB.nfloorUuid(this.address(), value);
            return this;
        }

        public Buffer floorUuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.floorUuid());
            return this;
        }

        public Buffer ceilingUuid(XrUuidEXT value) {
            XrRoomLayoutFB.nceilingUuid(this.address(), value);
            return this;
        }

        public Buffer ceilingUuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.ceilingUuid());
            return this;
        }

        public Buffer wallUuidCapacityInput(@NativeType(value="uint32_t") int value) {
            XrRoomLayoutFB.nwallUuidCapacityInput(this.address(), value);
            return this;
        }

        public Buffer wallUuidCountOutput(@NativeType(value="uint32_t") int value) {
            XrRoomLayoutFB.nwallUuidCountOutput(this.address(), value);
            return this;
        }

        public Buffer wallUuids(@NativeType(value="XrUuidEXT *") @Nullable XrUuidEXT.Buffer value) {
            XrRoomLayoutFB.nwallUuids(this.address(), value);
            return this;
        }
    }
}

