/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentLocationMSFT
extends Struct<XrSceneComponentLocationMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int POSE;

    protected XrSceneComponentLocationMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneComponentLocationMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneComponentLocationMSFT(address, container);
    }

    public XrSceneComponentLocationMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneComponentLocationMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long flags() {
        return XrSceneComponentLocationMSFT.nflags(this.address());
    }

    public XrPosef pose() {
        return XrSceneComponentLocationMSFT.npose(this.address());
    }

    public XrSceneComponentLocationMSFT flags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrSceneComponentLocationMSFT.nflags(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationMSFT pose(XrPosef value) {
        XrSceneComponentLocationMSFT.npose(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationMSFT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrSceneComponentLocationMSFT set(long flags, XrPosef pose) {
        this.flags(flags);
        this.pose(pose);
        return this;
    }

    public XrSceneComponentLocationMSFT set(XrSceneComponentLocationMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneComponentLocationMSFT malloc() {
        return new XrSceneComponentLocationMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneComponentLocationMSFT calloc() {
        return new XrSceneComponentLocationMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneComponentLocationMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneComponentLocationMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneComponentLocationMSFT create(long address) {
        return new XrSceneComponentLocationMSFT(address, null);
    }

    public static @Nullable XrSceneComponentLocationMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneComponentLocationMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneComponentLocationMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentLocationMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneComponentLocationMSFT malloc(MemoryStack stack) {
        return new XrSceneComponentLocationMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneComponentLocationMSFT calloc(MemoryStack stack) {
        return new XrSceneComponentLocationMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FLAGS));
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FLAGS), (long)value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrSceneComponentLocationMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneComponentLocationMSFT.__member((int)8), XrSceneComponentLocationMSFT.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentLocationMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentLocationMSFT ELEMENT_FACTORY = XrSceneComponentLocationMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSceneComponentLocationMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long flags() {
            return XrSceneComponentLocationMSFT.nflags(this.address());
        }

        public XrPosef pose() {
            return XrSceneComponentLocationMSFT.npose(this.address());
        }

        public Buffer flags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrSceneComponentLocationMSFT.nflags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrSceneComponentLocationMSFT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }
    }
}

