/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneComponentLocationMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentLocationsMSFT
extends Struct<XrSceneComponentLocationsMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATIONCOUNT;
    public static final int LOCATIONS;

    protected XrSceneComponentLocationsMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneComponentLocationsMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneComponentLocationsMSFT(address, container);
    }

    public XrSceneComponentLocationsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneComponentLocationsMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneComponentLocationsMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneComponentLocationsMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int locationCount() {
        return XrSceneComponentLocationsMSFT.nlocationCount(this.address());
    }

    @NativeType(value="XrSceneComponentLocationMSFT *")
    public @Nullable XrSceneComponentLocationMSFT.Buffer locations() {
        return XrSceneComponentLocationsMSFT.nlocations(this.address());
    }

    public XrSceneComponentLocationsMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneComponentLocationsMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT type$Default() {
        return this.type(1000097006);
    }

    public XrSceneComponentLocationsMSFT next(@NativeType(value="void *") long value) {
        XrSceneComponentLocationsMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT locationCount(@NativeType(value="uint32_t") int value) {
        XrSceneComponentLocationsMSFT.nlocationCount(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT locations(@NativeType(value="XrSceneComponentLocationMSFT *") @Nullable XrSceneComponentLocationMSFT.Buffer value) {
        XrSceneComponentLocationsMSFT.nlocations(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT set(int type, long next, int locationCount, @Nullable XrSceneComponentLocationMSFT.Buffer locations) {
        this.type(type);
        this.next(next);
        this.locationCount(locationCount);
        this.locations(locations);
        return this;
    }

    public XrSceneComponentLocationsMSFT set(XrSceneComponentLocationsMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneComponentLocationsMSFT malloc() {
        return new XrSceneComponentLocationsMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneComponentLocationsMSFT calloc() {
        return new XrSceneComponentLocationsMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneComponentLocationsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneComponentLocationsMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneComponentLocationsMSFT create(long address) {
        return new XrSceneComponentLocationsMSFT(address, null);
    }

    public static @Nullable XrSceneComponentLocationsMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneComponentLocationsMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneComponentLocationsMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentLocationsMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneComponentLocationsMSFT malloc(MemoryStack stack) {
        return new XrSceneComponentLocationsMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneComponentLocationsMSFT calloc(MemoryStack stack) {
        return new XrSceneComponentLocationsMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nlocationCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOCATIONCOUNT));
    }

    public static @Nullable XrSceneComponentLocationMSFT.Buffer nlocations(long struct) {
        return XrSceneComponentLocationMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)LOCATIONS)), XrSceneComponentLocationsMSFT.nlocationCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlocationCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOCATIONCOUNT), (int)value);
    }

    public static void nlocations(long struct, @Nullable XrSceneComponentLocationMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LOCATIONS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneComponentLocationsMSFT.nlocationCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneComponentLocationsMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneComponentLocationsMSFT.__member((int)4), XrSceneComponentLocationsMSFT.__member((int)POINTER_SIZE), XrSceneComponentLocationsMSFT.__member((int)4), XrSceneComponentLocationsMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATIONCOUNT = layout.offsetof(2);
        LOCATIONS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentLocationsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentLocationsMSFT ELEMENT_FACTORY = XrSceneComponentLocationsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSceneComponentLocationsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneComponentLocationsMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneComponentLocationsMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int locationCount() {
            return XrSceneComponentLocationsMSFT.nlocationCount(this.address());
        }

        @NativeType(value="XrSceneComponentLocationMSFT *")
        public @Nullable XrSceneComponentLocationMSFT.Buffer locations() {
            return XrSceneComponentLocationsMSFT.nlocations(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneComponentLocationsMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneComponentLocationsMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer locationCount(@NativeType(value="uint32_t") int value) {
            XrSceneComponentLocationsMSFT.nlocationCount(this.address(), value);
            return this;
        }

        public Buffer locations(@NativeType(value="XrSceneComponentLocationMSFT *") @Nullable XrSceneComponentLocationMSFT.Buffer value) {
            XrSceneComponentLocationsMSFT.nlocations(this.address(), value);
            return this;
        }
    }
}

