/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentMSFT
extends Struct<XrSceneComponentMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMPONENTTYPE;
    public static final int ID;
    public static final int PARENTID;
    public static final int UPDATETIME;

    protected XrSceneComponentMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneComponentMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneComponentMSFT(address, container);
    }

    public XrSceneComponentMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneComponentMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSceneComponentTypeMSFT")
    public int componentType() {
        return XrSceneComponentMSFT.ncomponentType(this.address());
    }

    public XrUuidMSFT id() {
        return XrSceneComponentMSFT.nid(this.address());
    }

    public XrUuidMSFT parentId() {
        return XrSceneComponentMSFT.nparentId(this.address());
    }

    @NativeType(value="XrTime")
    public long updateTime() {
        return XrSceneComponentMSFT.nupdateTime(this.address());
    }

    public XrSceneComponentMSFT componentType(@NativeType(value="XrSceneComponentTypeMSFT") int value) {
        XrSceneComponentMSFT.ncomponentType(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT id(XrUuidMSFT value) {
        XrSceneComponentMSFT.nid(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT id(Consumer<XrUuidMSFT> consumer) {
        consumer.accept(this.id());
        return this;
    }

    public XrSceneComponentMSFT parentId(XrUuidMSFT value) {
        XrSceneComponentMSFT.nparentId(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT parentId(Consumer<XrUuidMSFT> consumer) {
        consumer.accept(this.parentId());
        return this;
    }

    public XrSceneComponentMSFT updateTime(@NativeType(value="XrTime") long value) {
        XrSceneComponentMSFT.nupdateTime(this.address(), value);
        return this;
    }

    public XrSceneComponentMSFT set(int componentType, XrUuidMSFT id, XrUuidMSFT parentId, long updateTime) {
        this.componentType(componentType);
        this.id(id);
        this.parentId(parentId);
        this.updateTime(updateTime);
        return this;
    }

    public XrSceneComponentMSFT set(XrSceneComponentMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneComponentMSFT malloc() {
        return new XrSceneComponentMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneComponentMSFT calloc() {
        return new XrSceneComponentMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneComponentMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneComponentMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneComponentMSFT create(long address) {
        return new XrSceneComponentMSFT(address, null);
    }

    public static @Nullable XrSceneComponentMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneComponentMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneComponentMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneComponentMSFT malloc(MemoryStack stack) {
        return new XrSceneComponentMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneComponentMSFT calloc(MemoryStack stack) {
        return new XrSceneComponentMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncomponentType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COMPONENTTYPE));
    }

    public static XrUuidMSFT nid(long struct) {
        return XrUuidMSFT.create(struct + (long)ID);
    }

    public static XrUuidMSFT nparentId(long struct) {
        return XrUuidMSFT.create(struct + (long)PARENTID);
    }

    public static long nupdateTime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)UPDATETIME));
    }

    public static void ncomponentType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COMPONENTTYPE), (int)value);
    }

    public static void nid(long struct, XrUuidMSFT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ID), (long)XrUuidMSFT.SIZEOF);
    }

    public static void nparentId(long struct, XrUuidMSFT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PARENTID), (long)XrUuidMSFT.SIZEOF);
    }

    public static void nupdateTime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)UPDATETIME), (long)value);
    }

    static {
        Struct.Layout layout = XrSceneComponentMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneComponentMSFT.__member((int)4), XrSceneComponentMSFT.__member((int)XrUuidMSFT.SIZEOF, (int)XrUuidMSFT.ALIGNOF), XrSceneComponentMSFT.__member((int)XrUuidMSFT.SIZEOF, (int)XrUuidMSFT.ALIGNOF), XrSceneComponentMSFT.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMPONENTTYPE = layout.offsetof(0);
        ID = layout.offsetof(1);
        PARENTID = layout.offsetof(2);
        UPDATETIME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentMSFT ELEMENT_FACTORY = XrSceneComponentMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSceneComponentMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSceneComponentTypeMSFT")
        public int componentType() {
            return XrSceneComponentMSFT.ncomponentType(this.address());
        }

        public XrUuidMSFT id() {
            return XrSceneComponentMSFT.nid(this.address());
        }

        public XrUuidMSFT parentId() {
            return XrSceneComponentMSFT.nparentId(this.address());
        }

        @NativeType(value="XrTime")
        public long updateTime() {
            return XrSceneComponentMSFT.nupdateTime(this.address());
        }

        public Buffer componentType(@NativeType(value="XrSceneComponentTypeMSFT") int value) {
            XrSceneComponentMSFT.ncomponentType(this.address(), value);
            return this;
        }

        public Buffer id(XrUuidMSFT value) {
            XrSceneComponentMSFT.nid(this.address(), value);
            return this;
        }

        public Buffer id(Consumer<XrUuidMSFT> consumer) {
            consumer.accept(this.id());
            return this;
        }

        public Buffer parentId(XrUuidMSFT value) {
            XrSceneComponentMSFT.nparentId(this.address(), value);
            return this;
        }

        public Buffer parentId(Consumer<XrUuidMSFT> consumer) {
            consumer.accept(this.parentId());
            return this;
        }

        public Buffer updateTime(@NativeType(value="XrTime") long value) {
            XrSceneComponentMSFT.nupdateTime(this.address(), value);
            return this;
        }
    }
}

