/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneObjectMSFT
extends Struct<XrSceneObjectMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OBJECTTYPE;

    protected XrSceneObjectMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSceneObjectMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrSceneObjectMSFT(address, container);
    }

    public XrSceneObjectMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneObjectMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSceneObjectTypeMSFT")
    public int objectType() {
        return XrSceneObjectMSFT.nobjectType(this.address());
    }

    public XrSceneObjectMSFT objectType(@NativeType(value="XrSceneObjectTypeMSFT") int value) {
        XrSceneObjectMSFT.nobjectType(this.address(), value);
        return this;
    }

    public XrSceneObjectMSFT set(XrSceneObjectMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneObjectMSFT malloc() {
        return new XrSceneObjectMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSceneObjectMSFT calloc() {
        return new XrSceneObjectMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSceneObjectMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSceneObjectMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSceneObjectMSFT create(long address) {
        return new XrSceneObjectMSFT(address, null);
    }

    public static @Nullable XrSceneObjectMSFT createSafe(long address) {
        return address == 0L ? null : new XrSceneObjectMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSceneObjectMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneObjectMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSceneObjectMSFT malloc(MemoryStack stack) {
        return new XrSceneObjectMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSceneObjectMSFT calloc(MemoryStack stack) {
        return new XrSceneObjectMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nobjectType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OBJECTTYPE));
    }

    public static void nobjectType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OBJECTTYPE), (int)value);
    }

    static {
        Struct.Layout layout = XrSceneObjectMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneObjectMSFT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OBJECTTYPE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrSceneObjectMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneObjectMSFT ELEMENT_FACTORY = XrSceneObjectMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSceneObjectMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSceneObjectTypeMSFT")
        public int objectType() {
            return XrSceneObjectMSFT.nobjectType(this.address());
        }

        public Buffer objectType(@NativeType(value="XrSceneObjectTypeMSFT") int value) {
            XrSceneObjectMSFT.nobjectType(this.address(), value);
            return this;
        }
    }
}

