/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceContainerFB
extends Struct<XrSpaceContainerFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int UUIDCAPACITYINPUT;
    public static final int UUIDCOUNTOUTPUT;
    public static final int UUIDS;

    protected XrSpaceContainerFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpaceContainerFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceContainerFB(address, container);
    }

    public XrSpaceContainerFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceContainerFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceContainerFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceContainerFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int uuidCapacityInput() {
        return XrSpaceContainerFB.nuuidCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int uuidCountOutput() {
        return XrSpaceContainerFB.nuuidCountOutput(this.address());
    }

    @NativeType(value="XrUuidEXT *")
    public @Nullable XrUuidEXT.Buffer uuids() {
        return XrSpaceContainerFB.nuuids(this.address());
    }

    public XrSpaceContainerFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceContainerFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB type$Default() {
        return this.type(1000199000);
    }

    public XrSpaceContainerFB next(@NativeType(value="void const *") long value) {
        XrSpaceContainerFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB uuidCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSpaceContainerFB.nuuidCapacityInput(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB uuidCountOutput(@NativeType(value="uint32_t") int value) {
        XrSpaceContainerFB.nuuidCountOutput(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB uuids(@NativeType(value="XrUuidEXT *") @Nullable XrUuidEXT.Buffer value) {
        XrSpaceContainerFB.nuuids(this.address(), value);
        return this;
    }

    public XrSpaceContainerFB set(int type, long next, int uuidCapacityInput, int uuidCountOutput, @Nullable XrUuidEXT.Buffer uuids) {
        this.type(type);
        this.next(next);
        this.uuidCapacityInput(uuidCapacityInput);
        this.uuidCountOutput(uuidCountOutput);
        this.uuids(uuids);
        return this;
    }

    public XrSpaceContainerFB set(XrSpaceContainerFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceContainerFB malloc() {
        return new XrSpaceContainerFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpaceContainerFB calloc() {
        return new XrSpaceContainerFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpaceContainerFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpaceContainerFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpaceContainerFB create(long address) {
        return new XrSpaceContainerFB(address, null);
    }

    public static @Nullable XrSpaceContainerFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceContainerFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpaceContainerFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceContainerFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceContainerFB malloc(MemoryStack stack) {
        return new XrSpaceContainerFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceContainerFB calloc(MemoryStack stack) {
        return new XrSpaceContainerFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nuuidCapacityInput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UUIDCAPACITYINPUT));
    }

    public static int nuuidCountOutput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UUIDCOUNTOUTPUT));
    }

    public static @Nullable XrUuidEXT.Buffer nuuids(long struct) {
        return XrUuidEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)UUIDS)), XrSpaceContainerFB.nuuidCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nuuidCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)UUIDCAPACITYINPUT), (int)value);
    }

    public static void nuuidCountOutput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)UUIDCOUNTOUTPUT), (int)value);
    }

    public static void nuuids(long struct, @Nullable XrUuidEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)UUIDS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSpaceContainerFB.nuuidCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSpaceContainerFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceContainerFB.__member((int)4), XrSpaceContainerFB.__member((int)POINTER_SIZE), XrSpaceContainerFB.__member((int)4), XrSpaceContainerFB.__member((int)4), XrSpaceContainerFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        UUIDCAPACITYINPUT = layout.offsetof(2);
        UUIDCOUNTOUTPUT = layout.offsetof(3);
        UUIDS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceContainerFB, Buffer>
    implements NativeResource {
        private static final XrSpaceContainerFB ELEMENT_FACTORY = XrSpaceContainerFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSpaceContainerFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceContainerFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceContainerFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int uuidCapacityInput() {
            return XrSpaceContainerFB.nuuidCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int uuidCountOutput() {
            return XrSpaceContainerFB.nuuidCountOutput(this.address());
        }

        @NativeType(value="XrUuidEXT *")
        public @Nullable XrUuidEXT.Buffer uuids() {
            return XrSpaceContainerFB.nuuids(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceContainerFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000199000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceContainerFB.nnext(this.address(), value);
            return this;
        }

        public Buffer uuidCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSpaceContainerFB.nuuidCapacityInput(this.address(), value);
            return this;
        }

        public Buffer uuidCountOutput(@NativeType(value="uint32_t") int value) {
            XrSpaceContainerFB.nuuidCountOutput(this.address(), value);
            return this;
        }

        public Buffer uuids(@NativeType(value="XrUuidEXT *") @Nullable XrUuidEXT.Buffer value) {
            XrSpaceContainerFB.nuuids(this.address(), value);
            return this;
        }
    }
}

