/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceEraseInfoFB
extends Struct<XrSpaceEraseInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int LOCATION;

    protected XrSpaceEraseInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpaceEraseInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceEraseInfoFB(address, container);
    }

    public XrSpaceEraseInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceEraseInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceEraseInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceEraseInfoFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpaceEraseInfoFB.nspace(this.address());
    }

    @NativeType(value="XrSpaceStorageLocationFB")
    public int location() {
        return XrSpaceEraseInfoFB.nlocation(this.address());
    }

    public XrSpaceEraseInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceEraseInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB type$Default() {
        return this.type(1000158001);
    }

    public XrSpaceEraseInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceEraseInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB space(XrSpace value) {
        XrSpaceEraseInfoFB.nspace(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
        XrSpaceEraseInfoFB.nlocation(this.address(), value);
        return this;
    }

    public XrSpaceEraseInfoFB set(int type, long next, XrSpace space, int location) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.location(location);
        return this;
    }

    public XrSpaceEraseInfoFB set(XrSpaceEraseInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceEraseInfoFB malloc() {
        return new XrSpaceEraseInfoFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpaceEraseInfoFB calloc() {
        return new XrSpaceEraseInfoFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpaceEraseInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpaceEraseInfoFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpaceEraseInfoFB create(long address) {
        return new XrSpaceEraseInfoFB(address, null);
    }

    public static @Nullable XrSpaceEraseInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceEraseInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpaceEraseInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceEraseInfoFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceEraseInfoFB malloc(MemoryStack stack) {
        return new XrSpaceEraseInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceEraseInfoFB calloc(MemoryStack stack) {
        return new XrSpaceEraseInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOCATION));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOCATION), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrSpaceEraseInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceEraseInfoFB.__member((int)4), XrSpaceEraseInfoFB.__member((int)POINTER_SIZE), XrSpaceEraseInfoFB.__member((int)POINTER_SIZE), XrSpaceEraseInfoFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        LOCATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceEraseInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceEraseInfoFB ELEMENT_FACTORY = XrSpaceEraseInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSpaceEraseInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceEraseInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceEraseInfoFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpaceEraseInfoFB.nspace(this.address());
        }

        @NativeType(value="XrSpaceStorageLocationFB")
        public int location() {
            return XrSpaceEraseInfoFB.nlocation(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceEraseInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000158001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceEraseInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpaceEraseInfoFB.nspace(this.address(), value);
            return this;
        }

        public Buffer location(@NativeType(value="XrSpaceStorageLocationFB") int value) {
            XrSpaceEraseInfoFB.nlocation(this.address(), value);
            return this;
        }
    }
}

