/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpaceShareInfoFB
extends Struct<XrSpaceShareInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACECOUNT;
    public static final int SPACES;
    public static final int USERCOUNT;
    public static final int USERS;

    protected XrSpaceShareInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpaceShareInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrSpaceShareInfoFB(address, container);
    }

    public XrSpaceShareInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpaceShareInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpaceShareInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpaceShareInfoFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int spaceCount() {
        return XrSpaceShareInfoFB.nspaceCount(this.address());
    }

    @NativeType(value="XrSpace *")
    public PointerBuffer spaces() {
        return XrSpaceShareInfoFB.nspaces(this.address());
    }

    @NativeType(value="uint32_t")
    public int userCount() {
        return XrSpaceShareInfoFB.nuserCount(this.address());
    }

    @NativeType(value="XrSpaceUserFB *")
    public PointerBuffer users() {
        return XrSpaceShareInfoFB.nusers(this.address());
    }

    public XrSpaceShareInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrSpaceShareInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB type$Default() {
        return this.type(1000169001);
    }

    public XrSpaceShareInfoFB next(@NativeType(value="void const *") long value) {
        XrSpaceShareInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
        XrSpaceShareInfoFB.nspaces(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB users(@NativeType(value="XrSpaceUserFB *") PointerBuffer value) {
        XrSpaceShareInfoFB.nusers(this.address(), value);
        return this;
    }

    public XrSpaceShareInfoFB set(int type, long next, PointerBuffer spaces, PointerBuffer users) {
        this.type(type);
        this.next(next);
        this.spaces(spaces);
        this.users(users);
        return this;
    }

    public XrSpaceShareInfoFB set(XrSpaceShareInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpaceShareInfoFB malloc() {
        return new XrSpaceShareInfoFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpaceShareInfoFB calloc() {
        return new XrSpaceShareInfoFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpaceShareInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpaceShareInfoFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpaceShareInfoFB create(long address) {
        return new XrSpaceShareInfoFB(address, null);
    }

    public static @Nullable XrSpaceShareInfoFB createSafe(long address) {
        return address == 0L ? null : new XrSpaceShareInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpaceShareInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpaceShareInfoFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpaceShareInfoFB malloc(MemoryStack stack) {
        return new XrSpaceShareInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpaceShareInfoFB calloc(MemoryStack stack) {
        return new XrSpaceShareInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nspaceCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SPACECOUNT));
    }

    public static PointerBuffer nspaces(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACES)), (int)XrSpaceShareInfoFB.nspaceCount(struct));
    }

    public static int nuserCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)USERCOUNT));
    }

    public static PointerBuffer nusers(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)USERS)), (int)XrSpaceShareInfoFB.nuserCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspaceCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SPACECOUNT), (int)value);
    }

    public static void nspaces(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACES), (long)MemoryUtil.memAddress((CustomBuffer)value));
        XrSpaceShareInfoFB.nspaceCount(struct, value.remaining());
    }

    public static void nuserCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)USERCOUNT), (int)value);
    }

    public static void nusers(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERS), (long)MemoryUtil.memAddress((CustomBuffer)value));
        XrSpaceShareInfoFB.nuserCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)USERS)));
    }

    static {
        Struct.Layout layout = XrSpaceShareInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrSpaceShareInfoFB.__member((int)4), XrSpaceShareInfoFB.__member((int)POINTER_SIZE), XrSpaceShareInfoFB.__member((int)4), XrSpaceShareInfoFB.__member((int)POINTER_SIZE), XrSpaceShareInfoFB.__member((int)4), XrSpaceShareInfoFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACECOUNT = layout.offsetof(2);
        SPACES = layout.offsetof(3);
        USERCOUNT = layout.offsetof(4);
        USERS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrSpaceShareInfoFB, Buffer>
    implements NativeResource {
        private static final XrSpaceShareInfoFB ELEMENT_FACTORY = XrSpaceShareInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSpaceShareInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpaceShareInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpaceShareInfoFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int spaceCount() {
            return XrSpaceShareInfoFB.nspaceCount(this.address());
        }

        @NativeType(value="XrSpace *")
        public PointerBuffer spaces() {
            return XrSpaceShareInfoFB.nspaces(this.address());
        }

        @NativeType(value="uint32_t")
        public int userCount() {
            return XrSpaceShareInfoFB.nuserCount(this.address());
        }

        @NativeType(value="XrSpaceUserFB *")
        public PointerBuffer users() {
            return XrSpaceShareInfoFB.nusers(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpaceShareInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000169001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpaceShareInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
            XrSpaceShareInfoFB.nspaces(this.address(), value);
            return this;
        }

        public Buffer users(@NativeType(value="XrSpaceUserFB *") PointerBuffer value) {
            XrSpaceShareInfoFB.nusers(this.address(), value);
            return this;
        }
    }
}

