/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpacesLocateInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class XrSpacesLocateInfoKHR
extends XrSpacesLocateInfo {
    protected XrSpacesLocateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrSpacesLocateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new XrSpacesLocateInfoKHR(address, container);
    }

    public XrSpacesLocateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrSpacesLocateInfoKHR type(@NativeType(value="XrStructureType") int value) {
        XrSpacesLocateInfoKHR.ntype(this.address(), value);
        return this;
    }

    @Override
    public XrSpacesLocateInfoKHR type$Default() {
        return this.type(1000471000);
    }

    @Override
    public XrSpacesLocateInfoKHR next(@NativeType(value="void const *") long value) {
        XrSpacesLocateInfoKHR.nnext(this.address(), value);
        return this;
    }

    @Override
    public XrSpacesLocateInfoKHR baseSpace(XrSpace value) {
        XrSpacesLocateInfoKHR.nbaseSpace(this.address(), value);
        return this;
    }

    @Override
    public XrSpacesLocateInfoKHR time(@NativeType(value="XrTime") long value) {
        XrSpacesLocateInfoKHR.ntime(this.address(), value);
        return this;
    }

    @Override
    public XrSpacesLocateInfoKHR spaces(@NativeType(value="XrSpace const *") PointerBuffer value) {
        XrSpacesLocateInfoKHR.nspaces(this.address(), value);
        return this;
    }

    @Override
    public XrSpacesLocateInfoKHR set(int type, long next, XrSpace baseSpace, long time, PointerBuffer spaces) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.spaces(spaces);
        return this;
    }

    public XrSpacesLocateInfoKHR set(XrSpacesLocateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpacesLocateInfoKHR malloc() {
        return new XrSpacesLocateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpacesLocateInfoKHR calloc() {
        return new XrSpacesLocateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpacesLocateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpacesLocateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpacesLocateInfoKHR create(long address) {
        return new XrSpacesLocateInfoKHR(address, null);
    }

    public static @Nullable XrSpacesLocateInfoKHR createSafe(long address) {
        return address == 0L ? null : new XrSpacesLocateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpacesLocateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpacesLocateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpacesLocateInfoKHR malloc(MemoryStack stack) {
        return new XrSpacesLocateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpacesLocateInfoKHR calloc(MemoryStack stack) {
        return new XrSpacesLocateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrSpacesLocateInfo.Buffer {
        private static final XrSpacesLocateInfoKHR ELEMENT_FACTORY = XrSpacesLocateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrSpacesLocateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpacesLocateInfoKHR.ntype(this.address(), value);
            return this;
        }

        @Override
        public Buffer type$Default() {
            return this.type(1000471000);
        }

        @Override
        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpacesLocateInfoKHR.nnext(this.address(), value);
            return this;
        }

        @Override
        public Buffer baseSpace(XrSpace value) {
            XrSpacesLocateInfoKHR.nbaseSpace(this.address(), value);
            return this;
        }

        @Override
        public Buffer time(@NativeType(value="XrTime") long value) {
            XrSpacesLocateInfoKHR.ntime(this.address(), value);
            return this;
        }

        @Override
        public Buffer spaces(@NativeType(value="XrSpace const *") PointerBuffer value) {
            XrSpacesLocateInfoKHR.nspaces(this.address(), value);
            return this;
        }
    }
}

