/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSpatialAnchorNameHTC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSpatialAnchorCreateInfoHTC
extends Struct<XrSpatialAnchorCreateInfoHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACE;
    public static final int POSEINSPACE;
    public static final int NAME;

    protected XrSpatialAnchorCreateInfoHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSpatialAnchorCreateInfoHTC create(long address, @Nullable ByteBuffer container) {
        return new XrSpatialAnchorCreateInfoHTC(address, container);
    }

    public XrSpatialAnchorCreateInfoHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSpatialAnchorCreateInfoHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSpatialAnchorCreateInfoHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSpatialAnchorCreateInfoHTC.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrSpatialAnchorCreateInfoHTC.nspace(this.address());
    }

    public XrPosef poseInSpace() {
        return XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address());
    }

    public XrSpatialAnchorNameHTC name() {
        return XrSpatialAnchorCreateInfoHTC.nname(this.address());
    }

    public XrSpatialAnchorCreateInfoHTC type(@NativeType(value="XrStructureType") int value) {
        XrSpatialAnchorCreateInfoHTC.ntype(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC type$Default() {
        return this.type(1000319001);
    }

    public XrSpatialAnchorCreateInfoHTC next(@NativeType(value="void const *") long value) {
        XrSpatialAnchorCreateInfoHTC.nnext(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC space(XrSpace value) {
        XrSpatialAnchorCreateInfoHTC.nspace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC poseInSpace(XrPosef value) {
        XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC poseInSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInSpace());
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC name(XrSpatialAnchorNameHTC value) {
        XrSpatialAnchorCreateInfoHTC.nname(this.address(), value);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC name(Consumer<XrSpatialAnchorNameHTC> consumer) {
        consumer.accept(this.name());
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC set(int type, long next, XrSpace space, XrPosef poseInSpace, XrSpatialAnchorNameHTC name) {
        this.type(type);
        this.next(next);
        this.space(space);
        this.poseInSpace(poseInSpace);
        this.name(name);
        return this;
    }

    public XrSpatialAnchorCreateInfoHTC set(XrSpatialAnchorCreateInfoHTC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSpatialAnchorCreateInfoHTC malloc() {
        return new XrSpatialAnchorCreateInfoHTC(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoHTC calloc() {
        return new XrSpatialAnchorCreateInfoHTC(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSpatialAnchorCreateInfoHTC(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSpatialAnchorCreateInfoHTC create(long address) {
        return new XrSpatialAnchorCreateInfoHTC(address, null);
    }

    public static @Nullable XrSpatialAnchorCreateInfoHTC createSafe(long address) {
        return address == 0L ? null : new XrSpatialAnchorCreateInfoHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSpatialAnchorCreateInfoHTC.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSpatialAnchorCreateInfoHTC.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSpatialAnchorCreateInfoHTC malloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSpatialAnchorCreateInfoHTC calloc(MemoryStack stack) {
        return new XrSpatialAnchorCreateInfoHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static XrPosef nposeInSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINSPACE);
    }

    public static XrSpatialAnchorNameHTC nname(long struct) {
        return XrSpatialAnchorNameHTC.create(struct + (long)NAME);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void nposeInSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSEINSPACE), (long)XrPosef.SIZEOF);
    }

    public static void nname(long struct, XrSpatialAnchorNameHTC value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NAME), (long)XrSpatialAnchorNameHTC.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
    }

    static {
        Struct.Layout layout = XrSpatialAnchorCreateInfoHTC.__struct((Struct.Member[])new Struct.Member[]{XrSpatialAnchorCreateInfoHTC.__member((int)4), XrSpatialAnchorCreateInfoHTC.__member((int)POINTER_SIZE), XrSpatialAnchorCreateInfoHTC.__member((int)POINTER_SIZE), XrSpatialAnchorCreateInfoHTC.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrSpatialAnchorCreateInfoHTC.__member((int)XrSpatialAnchorNameHTC.SIZEOF, (int)XrSpatialAnchorNameHTC.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACE = layout.offsetof(2);
        POSEINSPACE = layout.offsetof(3);
        NAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSpatialAnchorCreateInfoHTC, Buffer>
    implements NativeResource {
        private static final XrSpatialAnchorCreateInfoHTC ELEMENT_FACTORY = XrSpatialAnchorCreateInfoHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSpatialAnchorCreateInfoHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSpatialAnchorCreateInfoHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSpatialAnchorCreateInfoHTC.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrSpatialAnchorCreateInfoHTC.nspace(this.address());
        }

        public XrPosef poseInSpace() {
            return XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address());
        }

        public XrSpatialAnchorNameHTC name() {
            return XrSpatialAnchorCreateInfoHTC.nname(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSpatialAnchorCreateInfoHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000319001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSpatialAnchorCreateInfoHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrSpatialAnchorCreateInfoHTC.nspace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(XrPosef value) {
            XrSpatialAnchorCreateInfoHTC.nposeInSpace(this.address(), value);
            return this;
        }

        public Buffer poseInSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInSpace());
            return this;
        }

        public Buffer name(XrSpatialAnchorNameHTC value) {
            XrSpatialAnchorCreateInfoHTC.nname(this.address(), value);
            return this;
        }

        public Buffer name(Consumer<XrSpatialAnchorNameHTC> consumer) {
            consumer.accept(this.name());
            return this;
        }
    }
}

