/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrTriangleMeshCreateInfoFB
extends Struct<XrTriangleMeshCreateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;
    public static final int WINDINGORDER;
    public static final int VERTEXCOUNT;
    public static final int VERTEXBUFFER;
    public static final int TRIANGLECOUNT;
    public static final int INDEXBUFFER;

    protected XrTriangleMeshCreateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrTriangleMeshCreateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrTriangleMeshCreateInfoFB(address, container);
    }

    public XrTriangleMeshCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrTriangleMeshCreateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrTriangleMeshCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrTriangleMeshCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrTriangleMeshFlagsFB")
    public long flags() {
        return XrTriangleMeshCreateInfoFB.nflags(this.address());
    }

    @NativeType(value="XrWindingOrderFB")
    public int windingOrder() {
        return XrTriangleMeshCreateInfoFB.nwindingOrder(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return XrTriangleMeshCreateInfoFB.nvertexCount(this.address());
    }

    @NativeType(value="XrVector3f const *")
    public @Nullable XrVector3f vertexBuffer() {
        return XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int triangleCount() {
        return XrTriangleMeshCreateInfoFB.ntriangleCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer indexBuffer(int capacity) {
        return XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), capacity);
    }

    public XrTriangleMeshCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrTriangleMeshCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB type$Default() {
        return this.type(1000117001);
    }

    public XrTriangleMeshCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrTriangleMeshCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB flags(@NativeType(value="XrTriangleMeshFlagsFB") long value) {
        XrTriangleMeshCreateInfoFB.nflags(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB windingOrder(@NativeType(value="XrWindingOrderFB") int value) {
        XrTriangleMeshCreateInfoFB.nwindingOrder(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB vertexCount(@NativeType(value="uint32_t") int value) {
        XrTriangleMeshCreateInfoFB.nvertexCount(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB vertexBuffer(@NativeType(value="XrVector3f const *") @Nullable XrVector3f value) {
        XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB triangleCount(@NativeType(value="uint32_t") int value) {
        XrTriangleMeshCreateInfoFB.ntriangleCount(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB indexBuffer(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB set(int type, long next, long flags, int windingOrder, int vertexCount, @Nullable XrVector3f vertexBuffer, int triangleCount, @Nullable IntBuffer indexBuffer) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        this.windingOrder(windingOrder);
        this.vertexCount(vertexCount);
        this.vertexBuffer(vertexBuffer);
        this.triangleCount(triangleCount);
        this.indexBuffer(indexBuffer);
        return this;
    }

    public XrTriangleMeshCreateInfoFB set(XrTriangleMeshCreateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrTriangleMeshCreateInfoFB malloc() {
        return new XrTriangleMeshCreateInfoFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrTriangleMeshCreateInfoFB calloc() {
        return new XrTriangleMeshCreateInfoFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrTriangleMeshCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrTriangleMeshCreateInfoFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrTriangleMeshCreateInfoFB create(long address) {
        return new XrTriangleMeshCreateInfoFB(address, null);
    }

    public static @Nullable XrTriangleMeshCreateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrTriangleMeshCreateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrTriangleMeshCreateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrTriangleMeshCreateInfoFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrTriangleMeshCreateInfoFB malloc(MemoryStack stack) {
        return new XrTriangleMeshCreateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrTriangleMeshCreateInfoFB calloc(MemoryStack stack) {
        return new XrTriangleMeshCreateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FLAGS));
    }

    public static int nwindingOrder(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WINDINGORDER));
    }

    public static int nvertexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VERTEXCOUNT));
    }

    public static @Nullable XrVector3f nvertexBuffer(long struct) {
        return XrVector3f.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)VERTEXBUFFER)));
    }

    public static int ntriangleCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TRIANGLECOUNT));
    }

    public static @Nullable IntBuffer nindexBuffer(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)INDEXBUFFER)), (int)capacity);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FLAGS), (long)value);
    }

    public static void nwindingOrder(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WINDINGORDER), (int)value);
    }

    public static void nvertexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VERTEXCOUNT), (int)value);
    }

    public static void nvertexBuffer(long struct, @Nullable XrVector3f value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VERTEXBUFFER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ntriangleCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TRIANGLECOUNT), (int)value);
    }

    public static void nindexBuffer(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INDEXBUFFER), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
    }

    static {
        Struct.Layout layout = XrTriangleMeshCreateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrTriangleMeshCreateInfoFB.__member((int)4), XrTriangleMeshCreateInfoFB.__member((int)POINTER_SIZE), XrTriangleMeshCreateInfoFB.__member((int)8), XrTriangleMeshCreateInfoFB.__member((int)4), XrTriangleMeshCreateInfoFB.__member((int)4), XrTriangleMeshCreateInfoFB.__member((int)POINTER_SIZE), XrTriangleMeshCreateInfoFB.__member((int)4), XrTriangleMeshCreateInfoFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        WINDINGORDER = layout.offsetof(3);
        VERTEXCOUNT = layout.offsetof(4);
        VERTEXBUFFER = layout.offsetof(5);
        TRIANGLECOUNT = layout.offsetof(6);
        INDEXBUFFER = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrTriangleMeshCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrTriangleMeshCreateInfoFB ELEMENT_FACTORY = XrTriangleMeshCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrTriangleMeshCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrTriangleMeshCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrTriangleMeshCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrTriangleMeshFlagsFB")
        public long flags() {
            return XrTriangleMeshCreateInfoFB.nflags(this.address());
        }

        @NativeType(value="XrWindingOrderFB")
        public int windingOrder() {
            return XrTriangleMeshCreateInfoFB.nwindingOrder(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return XrTriangleMeshCreateInfoFB.nvertexCount(this.address());
        }

        @NativeType(value="XrVector3f const *")
        public @Nullable XrVector3f vertexBuffer() {
            return XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int triangleCount() {
            return XrTriangleMeshCreateInfoFB.ntriangleCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer indexBuffer(int capacity) {
            return XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), capacity);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrTriangleMeshCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000117001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrTriangleMeshCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrTriangleMeshFlagsFB") long value) {
            XrTriangleMeshCreateInfoFB.nflags(this.address(), value);
            return this;
        }

        public Buffer windingOrder(@NativeType(value="XrWindingOrderFB") int value) {
            XrTriangleMeshCreateInfoFB.nwindingOrder(this.address(), value);
            return this;
        }

        public Buffer vertexCount(@NativeType(value="uint32_t") int value) {
            XrTriangleMeshCreateInfoFB.nvertexCount(this.address(), value);
            return this;
        }

        public Buffer vertexBuffer(@NativeType(value="XrVector3f const *") @Nullable XrVector3f value) {
            XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address(), value);
            return this;
        }

        public Buffer triangleCount(@NativeType(value="uint32_t") int value) {
            XrTriangleMeshCreateInfoFB.ntriangleCount(this.address(), value);
            return this;
        }

        public Buffer indexBuffer(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), value);
            return this;
        }
    }
}

